<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use App\Models\User;
use Session;
use Log;
use Auth;
class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/dashboard';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    /**
     * Show the application's login form.
     *
     * @return \Illuminate\Http\Response
     */
    public function showLoginForm()
    {
        return view('user.auth.login');
    }

    /**
     * Show the application registration form.
     *
     * @return \Illuminate\Http\Response
     */
    public function send_otp(Request $request)
    {
        //$otp = rand(pow(10, 4-1), pow(10, 4)-1);
        $otp = 123456;
        Session::put('otp',$otp);
        Session::put('country_code',$request->country_code);
        Session::put('mobile',$request->mobile);
        $user = User::where('mobile','=',$request->mobile)->first();
        

        if($user !=null){
            Log::info('New Dispatch : ' . $user->first_name);
            $number = $request->country_code.$request->mobile;
            $message = "DO NOT SHARE:".$otp." is the OTP for your account. Keep this OTP to yourself for account safety.";
            return response()->json(['data' => 'OTP send to your mobile number','success'=>1]);
            (new SendPushNotification)->sendSMSUser($number,$message);
        }else{
            return response()->json(['data' => 'Mobile number not matched!, Please create an account','success'=>0]);
        }
        
    }

    /**
     * Show the application registration form.
     *
     * @return \Illuminate\Http\Response
     */
    public function verify_otp(Request $request)
    {
        $otp = $request->otp;
        $session_otp = Session::get('otp','');
        $session_phone = Session::get('mobile','');
        if($otp ==$session_otp){
            $user = User::where('mobile','=',$session_phone)->first();
            if($user !=null){
                Auth::loginUsingId($user->id);
                return response()->json(['data' => 'OTP verified successfully','success'=>1]);
            }else{
                return response()->json(['data' => 'User not found','success'=>0]);
            }
        }else{
            return response()->json(['data' => 'OTP not matched!','success'=>0]);
        }
    }
}
