<?php

namespace App\Http\Controllers;

use App\Models\GpsHistory;
use Illuminate\Http\Request;
use Auth;
use App\Models\Provider;

class GpsHistoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $providers = Provider::orderBy('created_at' , 'desc')->get();
        return view('admin.gpshistory.index', compact('providers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\GpsHistory  $gpsHistory
     * @return \Illuminate\Http\Response
     */
    public function show(GpsHistory $gpsHistory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\GpsHistory  $gpsHistory
     * @return \Illuminate\Http\Response
     */
    public function edit(GpsHistory $gpsHistory)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\GpsHistory  $gpsHistory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, GpsHistory $gpsHistory)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\GpsHistory  $gpsHistory
     * @return \Illuminate\Http\Response
     */
    public function destroy(GpsHistory $gpsHistory)
    {
        //
    }

    public function time_list(Request $request)
    {
        $provider_id = $request->provider_id;
        $times = GpsHistory::where('provider_id','=',$provider_id)->orderBy('created_at' , 'desc')->take(500)->get();

        if(Auth::guard('admin')->user()){
            return view('admin.gpshistory.times', compact('times'));
        }elseif(Auth::guard('dispatcher')->user()){
            return view('dispatcher.gpshistory.times', compact('times'));
        }
    }
}
