<?php

namespace App\Http\Controllers\ProviderAuth;

use Illuminate\Http\Request;
use Illuminate\Database\QueryException;
use App\Http\Controllers\Controller;

use App\Notifications\ResetPasswordOTP;
use \Carbon\Carbon;
use Exception;

use Auth;
use Config;
use JWTAuth;
use Setting;
use Notification;
use Validator;
use Socialite;
use Twilio;
use Mail;
use App\Models\Admin;
use DateTimeZone;
use App\Models\Provider;
use App\Models\ProviderDevice;
use App\Models\ServiceType;
use App\Models\Vehicle;
use App\Models\Country;
use App\Models\ProviderToken;
use Illuminate\Support\Facades\Hash;

class TokenController extends Controller
{
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    // public function __construct()
    // {
    //     //$this->middleware('admin');


    //    //$this->middleware('dispatcher');
    //     $this->middleware(function ($request, $next) {
    //     $this->id = Auth::user()->id;
    //     $this->email = Auth::user()->email;
    //     $this->admin_type = Auth::user()->admin_type;
    //     $this->admin_id = Auth::user()->admin_id;

    //     if($this->admin_id !=  null){

    //          $admin = Admin::where('id','=',$this->admin_id)->first();

    //          if($admin->admin_type != 0 && $admin->time_zone != null){
    //              date_default_timezone_set($admin->time_zone);

    //          }
    //      }

    //     return $next($request);
    // });


    // }
    public function register(Request $request)
    {

                    // dd("hai");

        $validator = Validator::make($request->all(), [
            'name' => 'required|max:255',
           
            'email' => 'required|max:255',
            'mobile' => 'required',
            'password' => 'required|min:6',
            'dial_code' => 'required',
            'device_id' => 'required',
            'device_type' => 'required|in:android,ios',
            'device_token' => 'required',
            'service_type_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first(), 'success' => 0], 200);
        }



        $email_details = Provider::where('email','=',$request->email)->where('deleted_at',null)->first();

     
        if($email_details != null){
            return response()->json(['success' => "0", "message" => "The email already is exists"], 200);
        }
        $mobile_details = Provider::where('mobile','=',$request->mobile)->where('deleted_at',null)->first();
        if($mobile_details != null){
            return response()->json(['success' => "0", "message" => "The mobile already is exists"], 200);
        }
        // $token_user1 = ProviderToken::where('mobile', '=', $request->mobile)->where('code', $request->otp)->first();
        // if ($token_user1 == Null) {
        //     return response()->json(['success' => "0", "message" => "The given otp is invalid"], 200);
        // }

        try {
            $country = Country::where('dial_code', '=', $request->dial_code)->first();
            $Provider = $request->all();
            $Provider['allowed_service'] = $request->service_type_id;
            $Provider['password'] = bcrypt($request->otp);
            if ($country != null) {
                $Provider['country_id'] = $country->countryid;
            }
            $Provider = Provider::create($Provider);
            ProviderDevice::create([
                'provider_id' => $Provider->id,
                'udid' => $request->device_id,
                'token' => $request->device_token,
                'type' => $request->device_type,
            ]);

            Config::set('auth.providers.users.model', 'App\Models\Provider');
            $credentials = [];
            $credentials['mobile'] = $request->mobile;
            $credentials['password'] = $request->otp;

            if (!$token = auth('providerapi')->attempt($credentials)) {
                return response()->json(['message' => 'Mobile number or OTP incorrect', 'success' => 0], 200);
            }

            $Provider['password'] = bcrypt($request->password);
            $Provider->save();

            //    $Provider['token'] =$token;
            //    $Provider['token_type'] = 'Bearer';
            Provider::where('id', $Provider->id)->update(['status' => 'active', 'active_from' => Carbon::now(), 'password' => bcrypt($request->password)]);


            // $Provider['token'] = $token;
            // $Provider['token_type'] = 'Bearer';
            return response()->json(['access_token' => $token, 'token_type' => 'Bearer', 'data' => $Provider, 'success' => 1], 200);
            //return $Provider;

        } catch (Exception $e) {
            dd($e);
            return response()->json(['error' => 'Something went wrong, Please try again later!', 'success' => 0], 200);
        }
        
        // catch (QueryException $e) {
        //     // return $e;
        //     if ($request->ajax() || $request->wantsJson()) {
        //         return response()->json(['error' => 'Something went wrong, Please try again later!', 'success' => 0], 200);
        //     }
        //     return abort(500);
        // }
    }



    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function authenticate(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'device_id' => 'required',
            'device_type' => 'required|in:android,ios',
            'device_token' => 'required',
            //'mobile' => 'required|exists:providers,mobile',
            //'otp' => 'required',
            // 'email' => 'required|email',
            'password' => 'required|min:6',
            // 'vehicle_no' =>'required',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first(), 'success' => 0], 200);
        }

        // $token_user1 = ProviderToken::where('mobile','=',$request->mobile)->where('code',$request->otp)->first();
        //  if($token_user1 == Null)
        //  {
        //      return response()->json(['success' => "0", "message"=>"The given otp is invalide"], 200);
        //  }



        $password = $request->password;

        $provider = Provider::where('mobile', $request->mobile)->first();

        //   if($provider->dial_code != $request->dial_code){
        //     return response()->json(['message' => 'Invalid Country Code','success'=>0], 200);
        //   }


        // $mobile=Provider::where('mobile',$request->mobile)->first();
        // $mobile->password=bcrypt($password);
        // $mobile->save();

        Config::set('auth.providers.users.model', 'App\Models\Provider');

        // $credentials = $request->only('mobile', );
        // ,'dial_code'=>$request->dial_code
        $credentials = array('mobile' => $request->mobile, 'password' => $password);

        if (!$token = auth('providerapi')->attempt($credentials)) {
            return response()->json(['message' => 'Incorrect Mobile number or Password ', 'success' => 0], 200);
        }

        $Provider = Auth::guard('providerapi')->user();

        if ($Provider->admin_id) {
            $now = Carbon::now();
            $expired = $Provider->expires_at;
            if (Carbon::now() > $Provider->expires_at) {
                return response()->json(['message' => 'Your Account has been expired.Please contact your administrator', 'success' => 0], 200);
            }
        }

        // $vehicle = Vehicle::where('vehicle_no','=',$request->vehicle_no)->first();
        // if($vehicle !=null){
        //     $prev = Provider::where('mapping_id','=',$vehicle->id)->first();
        //     if($prev !=null && $prev->id !=$Provider->id){
        //         if($prev->status =='offline'){
        //             $prev->service_type_id = 0;
        //             $prev->mapping_id = 0;
        //             $prev->save();

        //             $Provider->login_status = 1;
        //             $Provider->mapping_id = $vehicle->id;
        //             $Provider->service_type_id = $vehicle->service_type_id;
        //             $Provider->save();
        //         }else{
        //             return response()->json(['message' => 'Vehicle is in Ride, Cannot change now','success'=>0], 200);
        //         }
        //     }else{
        //         $Provider->login_status = 1;
        //         $Provider->mapping_id = $vehicle->id;
        //         $Provider->service_type_id = $vehicle->service_type_id;
        //         $Provider->save();
        //     }
        // }else{
        //     return response()->json(['message' => 'Vehicle Not Found','success'=>0], 200);
        // }

        $Provider = Provider::with('device')->find(Auth::guard('providerapi')->user()->id);
        if ($Provider->device) {
            ProviderDevice::where('id', $Provider->device->id)->update([
                'udid' => $request->device_id,
                'token' => $request->device_token,
                'type' => $request->device_type,
            ]);
        } else {
            ProviderDevice::create([
                'provider_id' => $Provider->id,
                'udid' => $request->device_id,
                'token' => $request->device_token,
                'type' => $request->device_type,
            ]);
        }
        Provider::where('id', $Provider->id)->update(['status' => 'active', 'active_from' => Carbon::now()]);
        return response()->json([
            'token' => $token,
            'token_type' => "Bearer",
            'expires' => auth('providerapi')->factory()->getTTL() * 60,
            'success' => 1
        ]);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function logout(Request $request)
    {
        try {
            if (Auth::guard('providerapi')->user()->admin_id !=  null) {
                $admin = Admin::where('id', '=', Auth::guard('providerapi')->user()->admin_id)->first();
                if ($admin->admin_type != 0 && $admin->time_zone != null) {
                    date_default_timezone_set($admin->time_zone);
                }
            }
            ProviderDevice::where('provider_id', Auth::guard('providerapi')->user()->id)->update(['udid' => '', 'token' => '']);
            Provider::where('id', Auth::guard('providerapi')->user()->id)->update(['logout_at' => Carbon::now(), 'login_status' => 0, 'status' => 'offline']);
            auth()->logout();
            return response()->json(['message' => trans('api.logout_success')]);
        } catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }

    /**
     * Forgot Password.
     *
     * @return \Illuminate\Http\Response
     */


    public function forgot_password(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'email' => 'required|email|exists:providers,email',
        ]);

        if ($validator->fails()) {
            return response()->json(['success' => 0, 'message' => 'This Email Address Not Register By Unicotaxi.'], 200);
        }

        try {

            $provider = Provider::where('email', $request->email)->first();

            // $otp = mt_rand(1000, 9999);

            $otp = 1234;
            $provider->otp = $otp;
            $provider->save();

            // Notification::send($provider, new ResetPasswordOTP($otp));

            return response()->json([
                'success' => 1,
                'message' => 'OTP sent to your email and Mobile!',
                'provider' => $provider
            ]);
        } catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }


    /**
     * Reset Password.
     *
     * @return \Illuminate\Http\Response
     */

    public function reset_password(Request $request)
    {

        $this->validate($request, [
            'password' => 'required|confirmed|min:6',
            'id' => 'required|numeric|exists:providers,id'
        ]);

        try {

            $Provider = Provider::findOrFail($request->id);
            $Provider->password = bcrypt($request->password);
            $Provider->save();

            if ($request->ajax()) {
                return response()->json(['message' => 'Password Updated']);
            }
        } catch (Exception $e) {
            if ($request->ajax()) {
                return response()->json(['error' => trans('api.something_went_wrong')]);
            }
        }
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function refresh_token(Request $request)
    {

        Config::set('auth.providers.users.model', 'App\Models\Provider');

        $Provider = Provider::find(Auth::user()->id);

        try {
            if (!$token = JWTAuth::fromUser($Provider)) {
                return response()->json(['error' => 'Unauthenticated'], 401);
            }
        } catch (JWTException $e) {
            return response()->json(['error' => 'Something went wrong'], 500);
        }

        $Provider->access_token = $token;

        return response()->json($Provider);
    }

    /**
     * Get the token array structure.
     *
     * @param  string $token
     *
     * @return \Illuminate\Http\JsonResponse
     */
    protected function respondWithToken($token)
    {
        return response()->json([
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth('providerapi')->factory()->getTTL() * 60
        ]);
    }

    /**
     * help Details.
     *
     * @return \Illuminate\Http\Response
     */

    public function help_details(Request $request)
    {

        try {

            if ($request->ajax()) {
                return response()->json([
                    'contact_number' => Setting::get('contact_number', ''),
                    'contact_email' => Setting::get('contact_email', ''),
                    'contact_name' => Setting::get('contact_name', ''),
                    'privacy' => url("/privacy"),
                    'terms' => url("/terms-conditions"),
                    'faq' => url("/faq"),
                    'website' => url("/"),
                ]);
            }
        } catch (Exception $e) {
            if ($request->ajax()) {
                return  $e;
            }
        }
    }

    public function send_mobile(Request $request)
    {


        $this->validate($request, [
            'mobile' => 'required',
            'dial_code' => 'required',
        ]);

        $Provider = Provider::where('mobile', '=', $request->mobile)->first();
        $otp = 123456;

        if ($Provider == null) {
            $token_provider1 = ProviderToken::where('mobile', '=', $request->mobile)->first();
            if ($token_provider1) {
                $token_provider1->code = $otp;
                $token_provider1->dial_code = $request->dial_code;
                $token_provider1->mobile = $request->mobile;
                $token_provider1->save();
            } else {
                $token_provider = new ProviderToken;
                $token_provider->code = $otp;
                $token_provider->dial_code = $request->dial_code;
                $token_provider->mobile = $request->mobile;
                $token_provider->save();
            }
            return response()->json(['success' => 1, "otp" => $otp, 'is_user' => 0], 200);
        } else {
            // $token_provider1 = ProviderToken::where('mobile','=',$request->mobile)->first();
            // if($token_provider1)
            // {
            //     $token_provider1->code =$otp;
            //     $token_provider1->user_id =$Provider->id;
            //     $token_provider1->dial_code =$request->dial_code;
            //     $token_provider1->mobile =$request->mobile;
            //     $token_provider1->save();
            // }else{
            //     $token_provider = new ProviderToken;
            //     $token_provider->code =$otp;
            //     $token_provider->user_id =$Provider->id;
            //     $token_provider->dial_code =$request->dial_code;
            //     $token_provider->mobile =$request->mobile;
            //     $token_provider->save();
            // }

            return response()->json(['success' => 1, "otp" => $otp, 'is_user' => 1], 200);
        }

        // try {

        //     $User = Provider::where('mobile','=',$request->mobile)->first();
        //     if($User ==null){
        //         return response()->json(['success' => 0, "message"=>"Account details not found. Please contact Unicotaxi"], 200);
        //     }
        //     else{
        //         return response()->json(['success' => 1, "message"=>$User->otp], 200); 
        //     }
        // } 
        // catch (Exception $e) {
        //     return response()->json(['error' => trans('api.something_went_wrong')], 500);
        // }
    }

    public function service()
    {
        $service = ServiceType::where('status', 1)->select('id', 'name', 'keyword', 'shortcut')->get();

        return response()->json([
            'data' => $service,
        ]);
    }
    public function delete()
    {
        try {

            Provider::where('id', Auth::user()->id)->delete();

            // return response()->json(['message' => 'Usuario eliminado exitosamente', 'success' =>1], 200);
            return response()->json(['message' => 'User deleted successfully', 'success' => 1], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json(['message' => 'Something went Wrong', 'success' => 0], 200);
        }
    }
}
