<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\SendPushNotification;

use Stripe\Charge;
use Stripe\Stripe;
use Stripe\StripeInvalidRequestError;
use Stripe\Account;

use Auth;
use Setting;
use Exception;

use App\Models\ProviderCard;
use App\Models\Provider;
use App\Models\UserRequest;
use App\Models\UserRequestPayment;
class ProviderPaymentController extends Controller
{
    
     /**
     * add wallet money for user.
     *
     * @return \Illuminate\Http\Response
     */
    public function get_pendingdue(Request $request){

        try{
            $provider = Provider::find(Auth::user()->id);
            if($provider->due_balance !=0.00){
                return response()->json(['message' => 1, 'due_pending' =>$provider->due_balance]);
            }else{
                return response()->json(['message' => 0]);
            }
        } catch(Exception $e) {
            if($request->ajax()) {
                return response()->json(['error' => $e->getMessage()], 500);
            } else {
                return back()->with('flash_error', $e->getMessage());
            }
        }
    }
    /**
     * add wallet money for user.
     *
     * @return \Illuminate\Http\Response
     */
    public function pay_pendingdue(Request $request){

        $this->validate($request, [
                'card_id' => 'required|exists:provider_cards,card_id,provider_id,'.Auth::user()->id
            ]);

        try{
            $update_provider = Provider::find(Auth::user()->id);
            $cards = ProviderCard::where('provider_id',Auth::user()->id)->where('is_default',1)->first();
            $due_balance = $update_provider->due_balance;
            $StripeWalletCharge = $update_provider->due_balance * 100;
            Stripe::setApiKey(Setting::get('stripe_secret_key'));

            $Charge = Charge::create(array(
                  "amount" => $StripeWalletCharge,
                  "currency" => "usd",
                  "customer" => $update_provider->stripe_cust_id,
                  "card" => $request->card_id,
                  "description" => "Due Money for ".$update_provider->email." ".$update_provider->due_id,
                  "receipt_email" => $update_provider->email
                ));

            $update_provider->due_balance = 0;
            $update_provider->save();

            //sending push on adding wallet money
            //(new SendPushNotification)->DueMoney(Auth::user()->id,currency($due_balance));

            if($request->ajax()){
                return response()->json(['message' => 'Due amount '.currency_amt($due_balance).' debited from your account']); 
            } else {
                return redirect('wallet')->with('flash_success','Due amount '.currency_amt($due_balance).' debited from your account');
            }
        } catch(StripeInvalidRequestError $e) {
            if($request->ajax()){
                 return response()->json(['error' => $e->getMessage()], 500);
            }else{
                return back()->with('flash_error',$e->getMessage());
            }
        } catch(Exception $e) {
            if($request->ajax()) {
                return response()->json(['error' => $e->getMessage()], 500);
            } else {
                return back()->with('flash_error', $e->getMessage());
            }
        }
    }
}
