<?php

namespace App\Http\Controllers\ProviderResources;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Log;
use Auth;
use Setting;
use Exception;
use Carbon\Carbon;
use App\Helpers\Helper;
use App\Http\Controllers\SendPushNotification;
use Twilio;
use Mail;
use DateTimeZone;
use App\Models\User;
use App\Models\Admin;
use App\Models\Provider;
use App\Models\Vehicle;
use App\Models\FareModel;
use App\Models\Promocode;
use App\Models\PromocodeUsage;
use App\Models\UserRequest;
use App\Models\UserRequestPayment;
use App\Models\UserRequestRating;
use App\Models\ServiceType;
use App\Models\Waypoint;
use App\Models\GpsHistory;
use App\Models\Location;
use App\Models\RequestFilter;
use App\Models\MemberNotification;
use PushNotification;
use App\Models\ProviderWallet;
use App\Models\ContactList;

class TripController extends Controller
{

    /**
     * Toggle service availability of the provider.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function map_key(){
    
        $android_key = Setting::get('android_driver_map');
        $ios_key = Setting::get('ios_driver_map');

        return response()->json(['android_key' => $android_key,'ios_key'=>$ios_key]);
    }

    public function update_vehicle(Request $request)
    {
        $this->validate($request, [
                'vehicle_name' => 'required',
            ]);

        $Provider = Auth::user();
        $vehicle = Vehicle::where('vehicle_no','=',$request->vehicle_name)->first();
        if($vehicle !=null){
            $prev = Provider::where('mapping_id','=',$vehicle->id)->first();
            if($prev !=null){
                if($prev->status =='offline'){
                    $prev->service_type_id = 0;
                    $prev->mapping_id = 0;
                    $prev->save();
                }else{
                    return response()->json(['error' => 'Vehicle is in Ride, Cannot change now']);
                }
            }
            $Provider->mapping_id = $vehicle->id;
            $Provider->service_type_id = $vehicle->service_type_id;
            $Provider->save();
            return response()->json(['message' => 'Vehicle Updated Successfully']);
        }else{
            return response()->json(['error' => 'Vehicle Not Found']);
        }
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function status(Request $request){
       try{

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
            }
            if($Provider = Provider::find(Auth::user()->id)){
                if($Provider->mapping_id ==0) {
                    $message = '';
                }else{
                    $message='';
                }
                if($request->latitude !='' && $request->longitude !=''){
                    if($Provider->status =='riding'){
                        if($Provider->latitude != $request->latitude){
                            $Provider->ride_from = Carbon::now();
                        }
                    }
                    $Provider->latitude = $request->latitude;
                    $Provider->longitude = $request->longitude;
                    $Provider->save();
                    
                    $gps_history = GpsHistory::where('provider_id','=',Auth::user()->id)
                                  ->orderBy('id','desc')->first();
                    $now = Carbon::now()->subMinutes(1);
                    if($gps_history !=null ){
                        if($gps_history->created_at < $now){
                            $Gps = new GpsHistory;
                            $Gps->provider_id = Auth::user()->id;
                            $Gps->partner_id = Auth::user()->partner_id;
                            $Gps->latitude = $request->latitude;
                            $Gps->longitude = $request->longitude;
                            $Gps->save();
                        }
                    }else{
                        $Gps = new GpsHistory;
                        $Gps->provider_id = Auth::user()->id;
                        $Gps->partner_id = Auth::user()->partner_id;
                        $Gps->latitude = $request->latitude;
                        $Gps->longitude = $request->longitude;
                        $Gps->save();
                    }
                }
                  // return $Provider->trip_id;
                if($Provider->trip_id !=0){
                    $UserRequest = UserRequest::where('user_requests.id','=',$Provider->trip_id)
                    ->leftJoin('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
                    // ->where('status','!=', 'COMPLETED')
                    // ->where('status','!=', 'CANCELLED')
                    // ->select('user_requests.id','user_requests.user_name','user_requests.user_id','user_requests.provider_id','user_requests.booking_id','user_requests.status','user_requests.booking_by','user_requests.s_address','user_requests.s_latitude','user_requests.s_longitude','user_requests.d_address','user_requests.d_latitude','user_requests.d_longitude','user_requests.assigned_at','user_requests.message','user_requests.created_at','user_requests.service_type_id','service_types.id','service_types.home_screen_id')
                    ->select('user_requests.id as trip_id','user_requests.user_id','user_requests.user_name','user_requests.status','user_requests.paid','user_requests.s_latitude','user_requests.s_longitude','user_requests.d_latitude','user_requests.d_longitude','user_requests.stop1_latitude','user_requests.stop1_longitude','user_requests.stop2_latitude','user_requests.s_address','user_requests.stop2_longitude','user_requests.user_notes','user_requests.cancelled_by','user_requests.service_type_id','service_types.id','service_types.home_screen_id')->orderBy('user_requests.created_at', 'desc')->first();
                    if($UserRequest->user_id !=0){
                       $user=User::where('id',$UserRequest->user_id)->select('first_name','picture')->first();
                       if($user->picture){
                       $user_img=asset('storage/'.$user->picture);
                       }
                       else{
                       $user_img='https://ezrapp.website/storage/user/profile/user.png';
                       }
                       $user_name=$user->first_name;
                    }
                    else{
                       $user_img='';
                       $user_name=$UserRequest->user_name;
                    }
                    if($UserRequest){
                    $status =$UserRequest->status;
                    $trip_id =$UserRequest->trip_id;
                    $paid = $UserRequest->paid;
                    $s_latitude = $UserRequest->s_latitude;
                    $s_longitude = $UserRequest->s_longitude;
                    $d_latitude = $UserRequest->d_latitude;
                    $d_longitude = $UserRequest->d_longitude;
                    $stop1_latitude = $UserRequest->stop1_latitude;
                    $stop1_longitude = $UserRequest->stop1_longitude;
                    $stop2_latitude = $UserRequest->stop2_latitude;
                    $stop2_longitude = $UserRequest->stop2_longitude;
                    $user_notes=$UserRequest->user_notes;
                    $s_address=$UserRequest->s_address;
                    $cancelled_by=$UserRequest->cancelled_by;
                    $home_screen_id = $UserRequest->home_screen_id;
                    }
                    else{
                    $status ='';
                    $trip_id ='';
                    $paid ='';
                    $s_latitude = '';
                    $s_longitude = '';
                    $d_latitude = '';
                    $d_longitude = '';
                    $stop1_latitude = '';
                    $stop1_longitude ='';
                    $stop2_latitude = '';
                    $stop2_longitude = '';
                    $user_notes='';
                    $user_img='';
                    $user_name='';
                    $s_address='';
                    $cancelled_by='';
                    $home_screen_id = '';
                }               
                 // if($Provider->current_provider_id !=0){
                //     $UserRequest = UserRequest::where('current_provider_id','=',$Provider->id)->select('id','status','paid','s_latitude','s_longitude','d_latitude','d_longitude')->first();
                }else{
                    $status ='';
                    $trip_id ='';
                    $paid ='';
                    $s_latitude = '';
                    $s_longitude = '';
                    $d_latitude = '';
                    $d_longitude = '';
                    $stop1_latitude = '';
                    $stop1_longitude ='';
                    $stop2_latitude = '';
                    $stop2_longitude = '';
                    $user_notes='';
                    $user_img='';
                    $user_name='';
                    $s_address='';
                    $cancelled_by='';
                    $home_screen_id = '';
                }

                $alert_status = 0;
                $ride ='';
                

                $RequestFilter = RequestFilter::with('request')->where('provider_id','=', Auth::user()->id)->whereHas('request', function($query){
                        $query->where('status','=', 'SEARCHING');
                        $query->where('provider_id','=',0);
                        $query->where('current_provider_id',Auth::user()->id);
                    })->first();

                if($RequestFilter !=null){
                    $trip = UserRequest::where('user_requests.id','=',$RequestFilter->request_id)
                           ->leftJoin('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
                            ->where('user_requests.status','SEARCHING')
                            ->where('user_requests.provider_id','=',0)
                            ->select('user_requests.id','user_requests.user_name','user_requests.user_id','user_requests.provider_id','user_requests.booking_id','user_requests.status','user_requests.booking_by','user_requests.s_address','user_requests.s_latitude','user_requests.s_longitude','user_requests.d_address','user_requests.d_latitude','user_requests.d_longitude','user_requests.assigned_at','user_requests.message','user_requests.created_at','user_requests.service_type_id','service_types.id','service_types.home_screen_id')
                            
                            ->first();

                    if($trip !=null){
                    $Timeout = Setting::get('provider_select_timeout', 90);
                        $time_left_to_respond = $Timeout - (time() - strtotime($trip->assigned_at));
                        if($time_left_to_respond < 0) {
                            RequestFilter::where('provider_id', Auth::user()->id)
                                            ->where('request_id', $trip->id)
                                            ->delete();
                            Provider::where('id',Auth::user()->id)->update(['trip_id' => 0,'status' => 'active', 'active_from' =>Carbon::now()]);
                            $this->assign_next_provider($trip->id);
                        }else{
                            $trip->time_left_to_respond = $time_left_to_respond;
                            $alert_status = 1;
                            $ride = $trip;
                        }
                    }else{
                        RequestFilter::where('request_id', $trip->id)->delete();
                    }
                }

                return response()->json(['message'=>$message, 'data' => $status, 'trip_id' => $trip_id,'account_status' => $Provider->account_status, 'status' => $Provider->status, 'vehicle_number' => $Provider->mapping_id, 'paid' => $paid,'s_latitude' =>$s_latitude, 's_longitude' =>$s_longitude, 'd_latitude' =>$d_latitude, 'd_longitude' =>$d_longitude,'stop1_latitude' =>$stop1_latitude,'stop1_longitude' =>$stop1_longitude,'stop2_latitude' =>$stop2_latitude,'stop2_longitude' =>$stop2_longitude,'user_notes'=>$user_notes,'alert_status'=>$alert_status, 'ride'=>$ride,'provider_id'=>Auth::user()->id,
                    'picture'=>$user_img,'first_name'=>$user_name,'s_address'=>$s_address,'cancelled_by'=>$cancelled_by, 'home_screen_id' =>$home_screen_id]);
            }else{
                return response()->json(['error' => trans('api.user.user_not_found')], 500);
            }
        } catch(Exception $e){
            return $e;
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }
    
    public function destroy_notification($id)
    {
        try {
            RequestFilter::where('provider_id', Auth::user()->id)
                    ->where('request_id', $id)
                    ->delete();
            Provider::where('id',Auth::user()->id)->update(['trip_id' => 0,'status' => 'active', 'active_from' =>Carbon::now()]);

            $this->assign_next_provider($id);
            return response()->json(['success'=>'1','message' => 'Rejected Successfully']);
        } catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    public function assign_next_provider($request_id) {

        try {

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }

            $trip = UserRequest::where('id','=',$request_id)
                            ->where('status','SEARCHING')
                            ->where('provider_id','=',0)
                            ->first();
            if($trip !=null){
                $RequestFilter = RequestFilter::where('request_filters.request_id','=', $request_id)
                                ->join('providers','request_filters.provider_id','=','providers.id')
                                ->where('providers.status','=','active')
                                ->select('request_filters.*','providers.status as driver_status')
                                ->first();
                if($RequestFilter !=null){
                    $trip->assigned_at = Carbon::now();
                    $trip->current_provider_id = $RequestFilter->provider_id;
                    $trip->save();

                   $pro = Provider::where('id',$RequestFilter->provider_id)->update(['trip_id' =>$request_id]);
                    (new SendPushNotification)->IncomingTrip($RequestFilter->provider_id);
                }else{
                    $trip->cancelled_by = 'PROVIDER';
                    $trip->cancel_reason='Rejected By Drivers';
                    $trip->status = 'CANCELLED';
                    $trip->save();
                    RequestFilter::where('request_id', $trip->id)->delete();
                }
            }else{
                RequestFilter::where('request_id', $trip->id)->delete();
            }                
        } catch (ModelNotFoundException $e) {
            return false;
        }
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function gps_location(Request $request){
            
            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }

        if($Provider = Provider::find(Auth::user()->id)){
            if($request->latitude !='' && $request->longitude !=''){
                $Provider->latitude = $request->latitude;
                $Provider->longitude = $request->longitude;
                $Provider->save();
                
                $gps_history = GpsHistory::where('provider_id','=',Auth::user()->id)
                              ->orderBy('id','desc')->first();
                $now = Carbon::now()->subMinutes(1);
                if($gps_history !=null ){
                    if($gps_history->created_at < $now){
                        $Gps = new GpsHistory;
                        $Gps->provider_id = Auth::user()->id;
                        $Gps->partner_id = Auth::user()->partner_id;
                        $Gps->latitude = $request->latitude;
                        $Gps->longitude = $request->longitude;
                        $Gps->save();
                    }
                }else{
                    $Gps = new GpsHistory;
                    $Gps->provider_id = Auth::user()->id;
                    $Gps->partner_id = Auth::user()->partner_id;
                    $Gps->latitude = $request->latitude;
                    $Gps->longitude = $request->longitude;
                    $Gps->save();
                }
            }
            return response()->json(['message' =>'Location updated']);
        }else{
            return response()->json(['error' => trans('api.user.user_not_found')], 500);
        }
    }
    /**
     * Show the Offered Trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function offered_trips(){
    
        try{

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }
            
            $UserRequests = UserRequest::whereIn('status',['SEARCHING','SCHEDULED'])
                    ->where('provider_id','=', 0)
                    ->where('service_type_id','=', Auth::user()->service_type_id);

            if(Auth::user()->admin_id !=null){
                $UserRequests->where('admin_id','=',Auth::user()->admin_id);
            }        

            $UserRequests =  $UserRequests->where(function($q) {
                        $q->where('schedule_at', '<', Carbon::now()->addHour(Setting::get('feature_time')))
                          ->orWhereNull('schedule_at');
                    })
                    ->select('id','created_at','booking_id','service_type_id','s_address','d_address','distance','schedule_at','assigned_at','status','s_latitude','s_longitude','d_latitude','d_longitude')
                    ->orderBy('created_at','desc')
                    ->get();
                   // dd($UserRequests);
            $data = [];

            if(Setting::get('dispatch_algorithm') ==1){
                $provider =Provider::where('id',Auth::user()->id)->select('id','latitude','longitude')->first();
                foreach($UserRequests as $key=>$UserRequest){
                    $service = ServiceType::where('id',$UserRequest->service_type_id)->select('name','image')->first();
                    $UserRequests[$key]->service_name = $service->name;
                    $UserRequests[$key]->service_image = $service->image;
                    $start = Carbon::parse($UserRequest->assigned_at);
                    $now = Carbon::now();
                    $seconds = $now->diffInSeconds($start);
                    //dd($seconds);
                    if($seconds <= Setting::get('time_1', '10')){
                        $distance = Setting::get('distance_1', '500')/1000;
                        $latitude = $UserRequest->s_latitude;
                        $longitude = $UserRequest->s_longitude;
                        //dd($latitude);
                        $Providers = Provider::where('account_status', 'approved')
                            ->where('status', 'active')
                            ->selectRaw("id , (1.609344 * 3956 * acos( cos( radians('$latitude') ) * cos( radians(latitude) ) * cos( radians(longitude) - radians('$longitude') ) + sin( radians('$latitude') ) * sin( radians(latitude) ) ) ) AS distance")
                            ->having('distance', '<=', $distance)
                            ->orderBy('active_from', 'asc')
                            ->get()
                            ->pluck('id')->toArray();
                        if(count($Providers) >0){
                            if($provider->id = $Providers[0])
                            {
                                $data[]=$UserRequest;
                            }
                        }

                    }else{
                        $distance = Helper::distance($UserRequest->s_latitude, $UserRequest->s_longitude, $provider->latitude, $provider->longitude, "K");
                        if($seconds > Setting::get('time_1', '10') && $seconds < Setting::get('time_2', '20')){
                            $distance = $distance*1000;
                            if($distance <= Setting::get('distance_1', '500')){
                                $data[]=$UserRequest;
                            }
                        }else if($seconds > Setting::get('time_2', '20') && $seconds < Setting::get('time_3', '30')){
                            if($distance <=Setting::get('distance_2', '1')){
                                $data[]=$UserRequest;
                            }
                        }else if($seconds > Setting::get('time_3', '30') && $seconds < Setting::get('time_4', '40')){
                            if($distance <=Setting::get('distance_3', '2')){
                               $data[]=$UserRequest;     
                            }
                        }else if($seconds > Setting::get('time_4', '40') && $seconds < Setting::get('time_5', '50')){
                            if($distance <=Setting::get('distance_4', '3')){
                                $data[]=$UserRequest;
                            }
                        }else if($seconds > Setting::get('time_5', '50') && $seconds < Setting::get('time_6', '60')){
                            if($distance <=Setting::get('distance_5', '4')){
                                $data[]=$UserRequest;
                            }
                        }else if($seconds > Setting::get('time_6', '60')){
                                $data[]=$UserRequest;
                        }else{

                        }
                    }
                }
            }else{
                foreach($UserRequests as $key=>$UserRequest){
                    $service = ServiceType::where('id',$UserRequest->service_type_id)->select('name','image')->first();
                    $UserRequests[$key]->service_name = $service->name;
                    $UserRequests[$key]->service_image = $service->image;
                    $data[]=$UserRequest;
                }

            }
            $now = Carbon::now()->addMinutes(60);
            if(count($data) > 0){
                foreach($data as $key => $UserRequest){
                    if($UserRequest->schedule_at !=null){
                        $locations = Location::select('tlatitude','tlongitude','location_name')->get();
                        foreach ($locations as $location) {
                            $vertices_y = array_filter(explode(',', $location->tlatitude));
                            $vertices_x = array_filter(explode(',', $location->tlongitude));
                            $points_polygon = count($vertices_x);

                            $latitude_y = $UserRequest->s_latitude;
                            $longitude_x = $UserRequest->s_longitude;
                            if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                                $data[$key]->s_address = $location->location_name;
                            }

                            $latitude_y = $UserRequest->d_latitude;
                            $longitude_x = $UserRequest->d_longitude;
                            if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                                $data[$key]->d_address = $location->location_name;
                            }
                        }
                    }
                }
            }
            // return response()->json(['data' => $data, 'success' =>1]);
        }
        catch (Exception $e){
            return  response()->json(['error' => trans('api.something_went_wrong'), 'success' =>0], 500);
        }
    }

    /**
     * Show the Offered Trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function offered_details(Request $request, $id) {
    
        try{

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }

            $UserRequests = UserRequest::where('id','=', $id)->where('provider_id','=', 0)
                    ->select('id','user_name','user_mobile','guest','created_at','booking_id','user_id','service_type_id','schedule_at','s_address','s_latitude','s_longitude','d_address','d_latitude','d_longitude','message','route_key','distance','status','corporate_id','payment_mode')
                    ->first();
            if(!empty($UserRequests)){
                $UserRequests->distance = $UserRequests->distance.Setting::get('distance_unit');
                $service = ServiceType::where('id',$UserRequests->service_type_id)->select('name','image')->first();
                $UserRequests->service_name = $service->name;
                $UserRequests->service_image = $service->image;
                $UserRequests->user = User::where('id',$UserRequests->user_id)->select('name','mobile','picture','rating')->first();
                $UserRequests->user_name = $UserRequests->user_name;
                $now = Carbon::now()->addMinutes(60);
                if($UserRequests->schedule_at !=null){
                    $locations = Location::select('tlatitude','tlongitude','location_name')->get();
                    foreach ($locations as $location) {
                        $vertices_y = array_filter(explode(',', $location->tlatitude));
                        $vertices_x = array_filter(explode(',', $location->tlongitude));
                        $points_polygon = count($vertices_x);

                        $latitude_y = $UserRequests->s_latitude;
                        $longitude_x = $UserRequests->s_longitude;
                        if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                            $UserRequests->s_address = $location->location_name;
                        }

                        $latitude_y = $UserRequests->d_latitude;
                        $longitude_x = $UserRequests->d_longitude;
                        if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                            $UserRequests->d_address = $location->location_name;
                        }
                    }
                }

            }else{
                return response()->json(['data' => $UserRequests, 'success' =>1]);
            }
            return response()->json(['data' => $UserRequests, 'success' =>1]);
        }
        catch (Exception $e){
            return response()->json(['message' => trans('api.something_went_wrong'), 'success' =>0]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function accept_trips(Request $request, $id)
    {
        try {

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }

            if(Auth::user()->account_status !='approved'){
                return response()->json(['error' => 'You account has not been approved for driving', 'success' =>0]);
            }

            $UserRequest = UserRequest::findOrFail($id);

            if($UserRequest->status != "SEARCHING" && $UserRequest->status != "SCHEDULED") {
                return response()->json(['error' => 'Request already under progress!', 'success' =>0]);
            }

            // if(Auth::user()->trip_id != 0){
            //     return response()->json(['message' => 'Already in trip. Cannot take multiple at a time', 'success' =>0]);
            // }
            
            if(Auth::user()->status !='active'){
                return response()->json(['message' => 'Please go to Online to take Trip', 'success' =>0]);
            }


            // $UserRequest = UserRequest::findOrFail($id);
            if($UserRequest->schedule_at !=null){
                $manual_time =Setting::get('manual_time');
                $now = Carbon::now()->addMinutes($manual_time);
                // if($UserRequest->schedule_at > $now){
                //     return response()->json(['message' => 'You cannot start trip Before 1 Hour.', 'success' =>0]);
                // }
            }

            // if($UserRequest->status !='ACCEPTED'){
            //     return response()->json(['message' => 'Cannot change Status', 'success' =>0]);
            // }
            // $fare_calc = app(\App\Http\Controllers\UserApiController::class)->fare_calc(0,$UserRequest->service_type_id, $UserRequest->s_latitude, $UserRequest->s_longitude, $UserRequest->d_latitude, $UserRequest->d_longitude,$UserRequest->distance, $UserRequest->minutes);
            // $UserRequest->estimated_fare = round($fare_calc['fare_flat'],2);

            $UserRequest->provider_id = Auth::user()->id;
            // $UserRequest->status = 'ACCEPTED';
            $UserRequest->status = "STARTED";
            $UserRequest->vehicle_id = Auth::user()->mapping_id;
            $UserRequest->partner_id = Auth::user()->partner_id;
            $UserRequest->accepted_at = Carbon::now();
            $UserRequest->save();
            RequestFilter::where('request_id', $id)->delete();
            
            Provider::where('id',Auth::user()->id)->update(['status' =>'riding','trip_id' => $UserRequest->id]);

            if($UserRequest->user_id !=0){
                (new SendPushNotification)->RideAccepted($UserRequest);
            }
            return response()->json([
                'message' => 'Trip Accepted successfully',
                'request_id' => $UserRequest->id,
                'booking_by' => $UserRequest->booking_by,
                'success' =>1
            ]);

        }catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong'), 'success' =>0]);
        }
    }
    /**
     * Cancel given request.
     *
     * @return \Illuminate\Http\Response
     */
    public function cancel_trips(Request $request)
    {
        $this->validate($request, [
            'request_id' =>'required',
            'cancel_reason'=> 'max:255',
            'cancel_request'=> 'required|numeric',
        ]);
        try{

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }

        $UserRequest = UserRequest::where('id','=', $request->request_id)->where('provider_id','=', Auth::user()->id)->first();
            if($UserRequest->status != "SEARCHING" || $UserRequest->status != "SCHEDULED"){
                if($UserRequest->status =='STARTED' || $UserRequest->status =='ARRIVED'){
                    //User::where('id', $UserRequest->user_id)->update(['trip_id' => 0]);
                    Provider::where('id',Auth::user()->id)->update(['status' =>'active','trip_id' => 0, 'active_from' =>Carbon::now()]);
                }
                //Driver can cancell trip before i hour
                $now = Carbon::now()->subMinutes(60);
                if($UserRequest->schedule_at !=Null && $UserRequest->schedule_at < $now){
                    $UserRequest->provider_id = 0;
                    $UserRequest->partner_id = 0;
                    $UserRequest->cancelled_by ="NONE";
                    $UserRequest->cancel_reason ="";
                    $UserRequest->booking_by ="APP";
                    $UserRequest->paid =0;
                    $UserRequest->assigned_at = Carbon::now();
                    $UserRequest->push = 'AUTO';
                    $UserRequest->status ="SCHEDULED";
                    $UserRequest->save();

                    return response()->json([
                        'message' => 'Trip Cancelled Successfully',
                        'request_id' => $UserRequest->id,
                        'success'=>1
                    ]);
                }
                /*$UserRequest->status = "CANCELLED";
                $UserRequest->cancel_reason = $request->cancel_reason;
                $UserRequest->cancel_request = $request->cancel_request;
                $UserRequest->cancelled_by = "PROVIDER";
                $UserRequest->save();
                Provider::where('id',Auth::user()->id)->update(['status' =>'active','trip_id' => 0, 'active_from' =>Carbon::now()]);*/
                /*if($UserRequest->user_id !=0){
                    User::where('id', $UserRequest->user_id)->update(['trip_id' => 0]);
                    (new SendPushNotification)->ProviderCancellRide($UserRequest);
                }*/

                $UserRequest->provider_id = 0;
                $UserRequest->partner_id = 0;
                $UserRequest->cancelled_by ="NONE";
                $UserRequest->cancel_reason ="";
                $UserRequest->booking_by ="APP";
                $UserRequest->paid =0;
                $UserRequest->assigned_at = Carbon::now();
                $UserRequest->push = 'AUTO';
                $UserRequest->status ="SEARCHING";
                $UserRequest->save();

                return response()->json([
                    'message' => 'Trip Cancelled Successfully',
                    'request_id' => $UserRequest->id,
                    'success'=>1
                ]);

            }else{
                return response()->json(['message' => 'Cannot cancel request at this stage!', 'success'=>0]);
            }

        } catch (ModelNotFoundException $e) {
            return response()->json(['message' => 'Something went wrong', 'success'=>0]);
        }
    }
    /**
     * Show the planned trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function planned_trips() {
    
        try{
            $UserRequests = UserRequest::where('status', '=', 'ACCEPTED')
                    ->where('provider_id', '=', Auth::user()->id)
                    ->where('schedule_at', '=', null)
                    ->select('id','created_at','booking_id','service_type_id','schedule_at','s_address','d_address','distance','status')
                    ->orderBy('created_at','desc')
                    ->get();
            foreach($UserRequests as $key=>$UserRequest){
                $service = ServiceType::where('id',$UserRequest->service_type_id)->select('name','image')->first();
                $UserRequests[$key]->service_name = $service->name;
                $UserRequests[$key]->service_image = $service->image;
            }
            return response()->json([
                    'data' => $UserRequests,
                ]);        
        }
        catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    /**
     * Show the Offered Trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function planned_details(Request $request, $id) {
    
        try{

            $UserRequests = UserRequest::where('id','=', $id)->where('status', '=', 'ACCEPTED')->where('provider_id','=', Auth::user()->id)
                    ->select('id','user_name','user_mobile','guest','created_at','booking_id','user_id','service_type_id','schedule_at','s_address','s_latitude','s_longitude','d_address','d_latitude','d_longitude','message','route_key','distance','status','corporate_id','payment_mode')
                    ->first();
               if(!empty($UserRequests)){
                    $UserRequests->distance = $UserRequests->distance.Setting::get('distance_unit');
                    $UserRequests->service_name = ServiceType::where('id',$UserRequests->service_type_id)->pluck('name')->first();
                    $UserRequests->user = User::where('id',$UserRequests->user_id)->select('name','mobile','picture','rating')->first();
                    $UserRequests->user_name = $UserRequests->user_name;           
                }else{
                    return response()->json(['data' => $UserRequests]);
                }
           //dd($UserRequests);
            return response()->json(['data' => $UserRequests]);
        }
        catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    /**
     * Show the planned trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function scheduled_trips() {
    
        try{    

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }

            $UserRequests = UserRequest::where('status', '=', 'ACCEPTED')
                    ->where('provider_id', '=', Auth::user()->id)
                    ->where('schedule_at', '!=', null)
                    ->select('id','created_at','booking_id','service_type_id','schedule_at','s_address','d_address','distance','status','s_latitude','s_longitude','d_latitude','d_longitude')
                    ->orderBy('created_at','desc')
                    ->get();
            $now = Carbon::now()->addMinutes(60);
            foreach($UserRequests as $key=>$UserRequest){
                $service = ServiceType::where('id',$UserRequest->service_type_id)->select('name','image')->first();
                $UserRequests[$key]->service_name = $service->name;
                $UserRequests[$key]->service_image = $service->image;

                if($UserRequest->schedule_at !=null && $now < $UserRequest->schedule_at){
                    $locations = Location::select('tlatitude','tlongitude','location_name')->get();
                    foreach ($locations as $location) {
                        $vertices_y = array_filter(explode(',', $location->tlatitude));
                        $vertices_x = array_filter(explode(',', $location->tlongitude));
                        $points_polygon = count($vertices_x);

                        $latitude_y = $UserRequest->s_latitude;
                        $longitude_x = $UserRequest->s_longitude;
                        if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                            $UserRequests[$key]->s_address = $location->location_name;
                        }

                        $latitude_y = $UserRequest->d_latitude;
                        $longitude_x = $UserRequest->d_longitude;
                        if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                            $UserRequests[$key]->d_address = $location->location_name;
                        }
                    }
                }
            }

            return response()->json([
                    'data' => $UserRequests,
                ]);        
        }
        catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    /**
     * Show the Offered Trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function scheduled_details(Request $request, $id) {
    
        try{

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }

            $UserRequests = UserRequest::where('id','=', $id)->where('status', '=', 'ACCEPTED')->where('provider_id','=', Auth::user()->id)
                    ->select('id','user_name','user_mobile','guest','created_at','booking_id','user_id','service_type_id','schedule_at','s_address','s_latitude','s_longitude','d_address','d_latitude','d_longitude','message','route_key','distance','status','corporate_id','payment_mode')
                    ->first();
               if(!empty($UserRequests)){
                    $UserRequests->distance = $UserRequests->distance.Setting::get('distance_unit');
                    $UserRequests->service_name = ServiceType::where('id',$UserRequests->service_type_id)->pluck('name')->first();
                    $UserRequests->user = User::where('id',$UserRequests->user_id)->select('name','mobile','picture','rating')->first();
                    $UserRequests->user_name = $UserRequests->user_name;

                    $now = Carbon::now()->addMinutes(60);
                    if($UserRequests->schedule_at !=null && $now < $UserRequests->schedule_at){
                        $locations = Location::select('tlatitude','tlongitude','location_name')->get();
                        foreach ($locations as $location) {
                            $vertices_y = array_filter(explode(',', $location->tlatitude));
                            $vertices_x = array_filter(explode(',', $location->tlongitude));
                            $points_polygon = count($vertices_x);

                            $latitude_y = $UserRequests->s_latitude;
                            $longitude_x = $UserRequests->s_longitude;
                            if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                                $UserRequests->s_address = $location->location_name;
                            }

                            $latitude_y = $UserRequests->d_latitude;
                            $longitude_x = $UserRequests->d_longitude;
                            if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                                $UserRequests->d_address = $location->location_name;
                            }
                        }
                    }           
                }else{
                    return response()->json(['message' => 'Trip status changed', 'success'=>0]);
                }
           
            return response()->json(['data' => $UserRequests, 'success'=>1]);
        }
        catch (Exception $e){
            return response()->json(['message' => trans('api.something_went_wrong'),'success'=>0]);
        }
    }
    /**
     * Show the completed trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function completed_trips(Request $request) {
    
        try{    

            if($request->type==0){
            $UserRequests = UserRequest::where('status', '=', 'COMPLETED')
                    ->where('provider_id', '=', Auth::user()->id)
                    ->select('id','created_at','booking_id','service_type_id','schedule_at','s_address','s_latitude','s_longitude','d_address','d_latitude','d_longitude','message','route_key','distance','status')
                    ->where('created_at', '>=', Carbon::today())         
                    ->orderBy('created_at','desc')
                    ->get();
            if(!empty($UserRequests)){
                foreach ($UserRequests as $key => $value) {
                    $UserRequests[$key]->distance = $value->distance.Setting::get('distance_unit');
                    $UserRequests[$key]->service_name = ServiceType::where('id',$value->service_type_id)->pluck('name')->first();       
                }
            }
            return $UserRequests;

            }

            $UserRequests = UserRequest::where('status', '=', 'COMPLETED')
                    ->where('provider_id', '=', Auth::user()->id)
                    ->select('id','created_at','booking_id','service_type_id','schedule_at','s_address','s_latitude','s_longitude','d_address','d_latitude','d_longitude','message','route_key','distance','status')
                    ->orderBy('created_at','desc')
                    ->get();
            if(!empty($UserRequests)){
                foreach ($UserRequests as $key => $value) {
                    $UserRequests[$key]->distance = $value->distance.Setting::get('distance_unit');
                    $UserRequests[$key]->service_name = ServiceType::where('id',$value->service_type_id)->pluck('name')->first();       
                }
            }
            return $UserRequests;
        }
        catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }
    /**
     * Show the Offered Trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function completed_details(Request $request, $id) {
    
        try{

            $UserRequests = UserRequest::where('id','=', $id)->where('status', '=', 'COMPLETED')
                    ->where('provider_id', '=', Auth::user()->id)
                    ->select('id','created_at','booking_id','service_type_id','schedule_at','s_address','s_latitude','s_longitude','d_address','d_latitude','d_longitude','message','route_key','distance','status')
                    ->first();
                if(!empty($UserRequests)){
                    $UserRequests->distance = $UserRequests->distance.Setting::get('distance_unit');
                    $UserRequests->service_name = ServiceType::where('id',$UserRequests->service_type_id)->pluck('name')->first();          
                }else{
                    return response()->json(['data' => $UserRequests]);
                }
           
            return response()->json(['data' => $UserRequests]);
        }
        catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    /**
     * Show the completed trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function past_trips() {
    
        try{
            $UserRequests = UserRequest::whereIn('user_requests.status', ['COMPLETED', 'CANCELLED'])
                    ->where('provider_id', '=', Auth::user()->id)
                    ->select('id','created_at','booking_id','service_type_id','schedule_at','s_address','s_latitude','s_longitude','d_address','d_latitude','d_longitude','message','route_key','distance','status','corporate_id')
                    ->orderBy('created_at','desc')
                    ->get();
            if(!empty($UserRequests)){
                foreach ($UserRequests as $key => $value) {
                    $UserRequests[$key]->distance = $value->distance.Setting::get('distance_unit');
                    $UserRequests[$key]->service_name = ServiceType::where('id',$value->service_type_id)->pluck('name')->first();       
                }
            }
            return response()->json(['data' => $UserRequests]);
        }
        catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }
    /**
     * Show the Offered Trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function past_details(Request $request, $id) {
    
        try{

            $UserRequests = UserRequest::where('user_requests.id','=', $id)
                    ->where('provider_id', '=', Auth::user()->id)
                    ->leftJoin('users', 'user_requests.user_id', '=', 'users.id')
                    ->select('user_requests.user_name','user_requests.user_mobile','user_requests.guest','users.rating','users.picture','user_requests.id','user_requests.created_at','user_requests.booking_id','user_requests.service_type_id','user_requests.package_detail','user_requests.schedule_at','user_requests.s_address','user_requests.s_latitude','user_requests.s_longitude','user_requests.d_address','user_requests.d_latitude','user_requests.d_longitude','user_requests.message','user_requests.route_key','user_requests.distance','user_requests.status','user_requests.corporate_id','user_requests.payment_mode')
                    ->first();
             // $UserRequests->picture = asset('storage/'.Auth::user()->avatar);
                    $UserRequests->picture=asset('storage/'.$UserRequests->picture);
                    
                if(!empty($UserRequests)){
                    $UserRequests->distance = $UserRequests->distance.Setting::get('distance_unit');
                    $UserRequests->service_name = ServiceType::where('id',$UserRequests->service_type_id)->pluck('name')->first();
                    if($UserRequests->status =='COMPLETED'){
                        $UserRequests->payment = UserRequestPayment::where('request_id',$UserRequests->id)->first();         
                    }
                }else{
                    return $UserRequests;
                }
           
            return $UserRequests;
        }
        catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function start_trips(Request $request, $id)
    {
        try {
            
            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }

            if(Auth::user()->account_status !='approved'){
                return response()->json(['message' => 'You account has not been approved for driving', 'success' =>0]);
            }

            if(Auth::user()->trip_id != 0){
                 return response()->json(['message' => 'Already in trip. Cannot take multiple at a time', 'success' =>0]);
            }
            
            if(Auth::user()->status !='active'){
                return response()->json(['message' => 'Please go to Online to take Trip', 'success' =>0]);
            }


            $UserRequest = UserRequest::findOrFail($id);
            if($UserRequest->schedule_at !=null){
                $manual_time =Setting::get('manual_time');
                $now = Carbon::now()->addMinutes($manual_time);
                if($UserRequest->schedule_at > $now){
                    return response()->json(['message' => 'You cannot start trip Before 1 Hour.', 'success' =>0]);
                }
            }

            if($UserRequest->status !='ACCEPTED'){
                 
                return response()->json([
                    'message' => 'Trip Started successfully',
                    'request_id' => $UserRequest->id,
                    'success' =>1
                ]);
                
                return response()->json(['message' => 'Cannot change Status', 'success' =>0]);
            }
            // $fare_calc = app(\App\Http\Controllers\UserApiController::class)->fare_calc(0,$UserRequest->service_type_id, $UserRequest->s_latitude, $UserRequest->s_longitude, $UserRequest->d_latitude, $UserRequest->d_longitude,$UserRequest->distance, $UserRequest->minutes);
            // $UserRequest->estimated_fare = round($fare_calc['fare_flat'],2);
            
            $UserRequest->status = "STARTED";
            $UserRequest->save();
            Provider::where('id',Auth::user()->id)->update(['status' =>'riding','trip_id' => $UserRequest->id]);
            if($UserRequest->user_id !=0){
                User::where('id',$UserRequest->user_id)->update(['trip_id' => $UserRequest->id]);
                (new SendPushNotification)->RideStarted($UserRequest);
            }
            return response()->json([
                'message' => 'Trip Started successfully',
                'request_id' => $UserRequest->id,
                'success' =>1
            ]);

        }catch (Exception $e){
            return response()->json(['message' => trans('api.something_went_wrong'), 'success' =>0]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function searching_detail(Request $request)
    {
        try {
            $UserRequests = UserRequest::where('user_requests.status', '=', 'SEARCHING')
            ->where('current_provider_id', '=', Auth::user()->id)
            ->leftJoin('users', 'user_requests.user_id', '=', 'users.id')
            ->leftJoin('package_deliveries', 'user_requests.package_deliver_id', '=', 'package_deliveries.id')
            ->leftJoin('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
            ->select('user_requests.user_name','user_requests.user_mobile','package_deliveries.name as package_delivery_type','user_requests.package_type','user_requests.guest','users.rating','users.picture','user_requests.id','user_requests.booking_id','user_requests.provider_id','user_requests.service_type_id','user_requests.message','user_requests.s_address','user_requests.s_latitude','user_requests.goods_loader','user_requests.s_longitude','user_requests.d_address','user_requests.d_latitude','user_requests.d_longitude','package_deliveries.name','user_requests.package_detail','service_types.name','service_types.image')
            ->orderBy('user_requests.id', 'desc')
            ->first();
             if($UserRequests->rating){
             $UserRequests->rating = $UserRequests->rating;
             }else{
                $UserRequests->rating ="5.00";
                }

             if($UserRequests->goods_loader==NULL){
                $UserRequests->goods_loader=0;
             }else{
                $UserRequests->goods_loader =$UserRequests->goods_loader;
                }
             
             if($UserRequests->picture){
             $UserRequests->picture = asset('storage/'.$UserRequests->picture);
             }
             else{
             $UserRequests->picture = '';
             }


             
             if($UserRequests->package_image){
                $UserRequests->package_image = $UserRequests->package_image;
            }
            else{
                $UserRequests->package_image ='';
            }

            if($UserRequests->package_image1){
                $UserRequests->package_image1 = $UserRequests->package_image1;
            }
            else{
                $UserRequests->package_image1 ='';
            }

            if($UserRequests->package_image2){
                $UserRequests->package_image2= $UserRequests->package_image2;
            }
            else{
                $UserRequests->package_image2 ='';
            }
            
            if($UserRequests->package_delivery_type){
                $UserRequests->package_type= $UserRequests->package_delivery_type;
            }
            else{
                $UserRequests->package_type ='';
            }

            if($UserRequests->package_detail){
                $UserRequests->package_detail= $UserRequests->package_detail;
            }
            else{
                $UserRequests->package_detail ='';
            }

             $UserRequests->customer_center = Setting::get('contact_number');

            return $UserRequests;
        }catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function start_detail(Request $request)
    {
        try {
            $UserRequests = UserRequest::where('user_requests.status', '=', 'STARTED')
            ->where('provider_id', '=', Auth::user()->id)
            ->leftJoin('users', 'user_requests.user_id', '=', 'users.id')
            ->leftJoin('package_deliveries', 'user_requests.package_deliver_id', '=', 'package_deliveries.id')
            ->leftJoin('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
            ->leftJoin('service_categories', 'user_requests.service_category_id', '=', 'service_categories.id')
            ->select('user_requests.user_name','user_requests.user_mobile','package_deliveries.name as package_delivery_type','user_requests.guest','user_requests.goods_loader','users.rating','users.picture','user_requests.id','user_requests.booking_id','user_requests.provider_id','user_requests.message','user_requests.s_address','user_requests.s_latitude','user_requests.package_detail','user_requests.s_longitude','user_requests.d_address','user_requests.d_latitude','user_requests.d_longitude','user_requests.service_type_id','service_types.name','service_types.image','user_requests.package_image','user_requests.package_image1','user_requests.package_image2','service_categories.name as van_type','user_requests.package_type')
            ->first();

            // if($UserRequests !=null){
            //     $UserRequests->picture = asset('storage/'.$UserRequests->picture);
            // }          
             if($UserRequests->rating){
             $UserRequests->rating = $UserRequests->rating;
             }
             else{
             $UserRequests->rating ="5.00";
             }

             if($UserRequests->goods_loader==NULL){
                $UserRequests->goods_loader=0;
             }else{
                $UserRequests->goods_loader =$UserRequests->goods_loader;
                }

              if($UserRequests->picture){
               $UserRequests->picture=asset('storage/'.$UserRequests->picture);
            }
            else{
               $UserRequests->picture='https://ezrapp.website/storage/user/profile/user.png';
            }
            if($UserRequests->avatar){
                $UserRequests->avatar =asset('storage/'.Auth::user()->avatar);
            }
            else{
                $UserRequests->avatar ='';
            }

            if($UserRequests->package_image){
                $UserRequests->package_image = $UserRequests->package_image;
            }
            else{
                $UserRequests->package_image ='';
            }

            if($UserRequests->package_image1){
                $UserRequests->package_image1 = $UserRequests->package_image1;
            }
            else{
                $UserRequests->package_image1 ='';
            }

            if($UserRequests->package_image2){
                $UserRequests->package_image2= $UserRequests->package_image2;
            }
            else{
                $UserRequests->package_image2 ='';
            }
            
            if($UserRequests->package_delivery_type){
                $UserRequests->package_type= $UserRequests->package_delivery_type;
            }
            else{
                $UserRequests->package_type ='';
            }

            if($UserRequests->package_detail){
                $UserRequests->package_detail= $UserRequests->package_detail;
            }
            else{
                $UserRequests->package_detail ='';
            }

            $UserRequests->customer_center = Setting::get('contact_number');
            return $UserRequests;
        }catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function arrived_trips(Request $request, $id)
    {
        try {

            $UserRequest = UserRequest::where('id',$id)->first();
            
            if($UserRequest->status !='STARTED'){
                return response()->json(['message' => 'Cannot change Status', 'success'=>0]);
            }
            $UserRequest->status = "ARRIVED";
            $UserRequest->save();
            
            (new SendPushNotification)->Arrived($UserRequest);
            
            return response()->json([
                'message' => 'You have arrived to Customer Location',
                'request_id' => $UserRequest->id,
                'success'=>1
            ]);
           
        }catch (Exception $e){
            dd($e);
            return response()->json(['message' => trans('api.something_went_wrong'),'success'=>0]);
        }
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function arrived_detail(Request $request)
    {
        try {
            $UserRequests = UserRequest::where('user_requests.status', '=', 'ARRIVED')
            ->where('provider_id', '=', Auth::user()->id)
            ->leftJoin('users', 'user_requests.user_id', '=', 'users.id')
            ->leftJoin('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
            ->leftJoin('package_deliveries', 'user_requests.package_deliver_id', '=', 'package_deliveries.id')
            ->leftJoin('service_categories', 'user_requests.service_category_id', '=', 'service_categories.id')
            ->select('user_requests.user_name','user_requests.user_mobile','package_deliveries.name as package_delivery_type','user_requests.guest','user_requests.goods_loader','users.rating','users.picture','user_requests.id','user_requests.booking_id','user_requests.provider_id','user_requests.message','user_requests.package_detail','user_requests.s_address','user_requests.s_latitude','user_requests.s_longitude','user_requests.d_address','user_requests.d_latitude','user_requests.d_longitude','user_requests.service_type_id','service_types.name','service_types.image','user_requests.package_image','user_requests.package_image1','user_requests.package_image2','service_categories.name as van_type','user_requests.package_type')
            ->first();

            // dd($UserRequests);
             if($UserRequests->picture){
             $UserRequests->picture = asset('storage/'.$UserRequests->picture);
             }
             else{
             $UserRequests->picture = 'https://ezrapp.website/storage/user/profile/user.png';
             }

             if($UserRequests->goods_loader==NULL){
                $UserRequests->goods_loader=0;
             }else{
                $UserRequests->goods_loader =$UserRequests->goods_loader;
                }

             if($UserRequests->package_image){
                $UserRequests->package_image = $UserRequests->package_image;
            }
            else{
                $UserRequests->package_image ='';
            }

            if($UserRequests->package_image1){
                $UserRequests->package_image1 = $UserRequests->package_image1;
            }
            else{
                $UserRequests->package_image1 ='';
            }

            if($UserRequests->package_image2){
                $UserRequests->package_image2= $UserRequests->package_image2;
            }
            else{
                $UserRequests->package_image2 ='';
            }
            
            if($UserRequests->package_delivery_type){
                $UserRequests->package_type= $UserRequests->package_delivery_type;
            }
            else{
                $UserRequests->package_type ='';
            }

            if($UserRequests->package_detail){
                $UserRequests->package_detail= $UserRequests->package_detail;
            }
            else{
                $UserRequests->package_detail ='';
            }


            if($UserRequests !=null){
                
                // $UserRequests->picture = asset('storage/'.$UserRequests->picture);
                $UserRequests->customer_center = Setting::get('contact_number');
                return $UserRequests;
            }else{
                return response()->json(['error' => 'Status not changed']);
            }
        }catch (Exception $e){
            // dd($e);
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function pickedup_trips(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'latitude' => 'required|numeric',
                'longitude' => 'required|numeric',
                'address' => 'required'
            ]);

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
            }

            $UserRequest = UserRequest::findOrFail($id);
            
            if($UserRequest->status !='ARRIVED'){
                return response()->json(['error' => 'Cannot change Status']);
            }
            $UserRequest->status = "PICKEDUP";
            $UserRequest->s_address = $request->address;
            $UserRequest->s_latitude = $request->latitude;
            $UserRequest->s_longitude = $request->longitude;
            if(preg_match("/(?:[01]\d|2[0123]):(?:[012345]\d):(?:[012345]\d)/", $request->trip_waiting_time)) {
                $UserRequest->waiting_time = $request->trip_waiting_time;
            }
            // $UserRequest->minutes = $request->minutes ? : 0;
            $UserRequest->started_at = Carbon::now();
            $UserRequest->save();

            return response()->json([
                'message' => 'You have pickedup the Customer',
                'request_id' => $UserRequest->id,
            ]);
           
        }catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function pickedup_detail(Request $request)
    {
        try {
            $provider=Provider::where('id',Auth::user()->id)->first();
            $UserRequests = UserRequest::where('user_requests.status', '=', 'PICKEDUP')
            ->where('provider_id', '=', Auth::user()->id)
            ->leftJoin('users', 'user_requests.user_id', '=', 'users.id')
            ->leftJoin('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
            ->leftJoin('package_deliveries', 'user_requests.package_deliver_id', '=', 'package_deliveries.id')
            ->leftJoin('service_categories', 'user_requests.service_category_id', '=', 'service_categories.id')
            ->select('user_requests.user_name','user_requests.user_mobile','package_deliveries.name as package_delivery_type','user_requests.guest','user_requests.goods_loader','users.rating','users.picture','user_requests.package_detail','user_requests.id','user_requests.booking_id','user_requests.provider_id','user_requests.message','user_requests.s_address','user_requests.s_latitude','user_requests.s_longitude','user_requests.d_address','user_requests.d_latitude','user_requests.d_longitude','user_requests.service_type_id','service_types.name','service_types.image','user_requests.package_image','user_requests.package_image1','user_requests.package_image2','service_categories.name as van_type','user_requests.package_type')
            ->orderBy('user_requests.created_at','desc')
            ->first();
            // $UserRequests->picture = asset('storage/'.$UserRequests->picture);
             if($UserRequests->picture){
             $UserRequests->picture = asset('storage/'.$UserRequests->picture);
             }
             else{
             $UserRequests->picture = 'https://ezrapp.website/storage/user/profile/user.png';
             }

             if($UserRequests->goods_loader==NULL){
                $UserRequests->goods_loader=0;
             }else{
                $UserRequests->goods_loader =$UserRequests->goods_loader;
                }
                
             if($UserRequests->package_image){
                $UserRequests->package_image = $UserRequests->package_image;
            }
            else{
                $UserRequests->package_image ='';
            }

            if($UserRequests->package_image1){
                $UserRequests->package_image1 = $UserRequests->package_image1;
            }
            else{
                $UserRequests->package_image1 ='';
            }

            if($UserRequests->package_image2){
                $UserRequests->package_image2= $UserRequests->package_image2;
            }
            else{
                $UserRequests->package_image2 ='';
            }
            
            if($UserRequests->package_delivery_type){
                $UserRequests->package_type= $UserRequests->package_delivery_type;
            }
            else{
                $UserRequests->package_type ='';
            }

            if($UserRequests->package_detail){
                $UserRequests->package_detail= $UserRequests->package_detail;
            }
            else{
                $UserRequests->package_detail ='';
            }


             $UserRequests->customer_center = Setting::get('contact_number');

            return $UserRequests;

        }catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    public function update_destination(Request $request)
    {
        try {

            $UserRequest = UserRequest::where('id',$request->id)->first();
            
            if($UserRequest->status == 'PICKEDUP'){

            	if($request->d_address){
                $UserRequest->d_address =$request->d_address;
                $UserRequest->d_latitude =$request->d_latitude;
                $UserRequest->d_longitude =$request->d_longitude;

                $unit =Setting::get('distance_unit');
                
                if($unit =='km'){
                    $kilometer = $request->distance;
                }else{
                    $base = $request->distance;
                    $kilometer = $base * 0.62137119;
                }


                $kilometer = round($kilometer,2);
                $minutes = $request->minutes;
                $service_category_id=0;
                if($UserRequest->service_category_id!="")
                {
                    $service_category_id=$UserRequest->service_category_id;
                }

                $fare_calc = app(\App\Http\Controllers\UserApiController::class)->fare_calc($service_category_id,$UserRequest->service_type_id, $UserRequest->s_latitude, $UserRequest->s_longitude, $request->d_latitude,$request->d_longitude,$kilometer, $minutes);
                $UserRequest->estimated_fare = round($fare_calc['fare_flat'],2);
                $UserRequest->fare_type =$fare_calc['fare_type'];
                $UserRequest->distance = $kilometer;
                $UserRequest->minutes = $minutes;
            	}
                if($request->stop1_address){
                $UserRequest->stop1_address =$request->stop1_address;
                $UserRequest->stop1_latitude =$request->stop1_latitude;
                $UserRequest->stop1_longitude =$request->stop1_longitude;
                }
                if($request->stop2_address){
                $UserRequest->stop2_address =$request->stop2_address;
                $UserRequest->stop2_latitude =$request->stop2_latitude;
                $UserRequest->stop2_longitude =$request->stop2_longitude;
                }

                $UserRequest->save();

                return response()->json([
                    'message' => 'Destination Updated to Customer Location',
                    'request_id' => $UserRequest->id,
                    'd_address' =>$UserRequest->d_address,
                    'd_latitude' =>$UserRequest->d_latitude,
                    'd_longitude' =>$UserRequest->d_longitude,
                    'stop1_address' =>$UserRequest->stop1_address,
                    'stop1_latitude' =>$UserRequest->stop1_latitude,
                    'stop1_longitude' =>$UserRequest->stop1_longitude,
                    'stop2_address' =>$UserRequest->stop2_address,
                    'stop2_latitude' =>$UserRequest->stop2_latitude,
                    'stop2_longitude' =>$UserRequest->stop2_longitude,
                    'success'=>1
                ]);
            }
            else{
                return response()->json(['message' => 'Cannot change Destination', 'success'=>0]);
            }
                       
        }catch (Exception $e){
            return response()->json(['message' => trans('api.something_went_wrong'),'success'=>0]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function dropped_trips(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'latitude' => 'required|numeric',
                'longitude' => 'required|numeric',
                'address' => 'required',
                'distance' => 'required',

            ]);

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
            }
            $UserRequest = UserRequest::findOrFail($id);
            $UserRequest->d_address = $request->address;
            $UserRequest->d_latitude = $request->latitude;
            $UserRequest->d_longitude = $request->longitude;
            $UserRequest->finished_at = Carbon::now();

            if(preg_match("/(?:[01]\d|2[0123]):(?:[012345]\d):(?:[012345]\d)/", $request->stop_waiting_time)) {
                $UserRequest->stop_waiting_time = $request->stop_waiting_time;
            }
            $unit =Setting::get('distance_unit');

            if($unit =='km'){
                $kilometer = $request->distance;
            }else{
                $base = $request->distance/1000;
                $kilometer = $base * 0.62137119;
            }
            
            $UserRequest->distance = round($kilometer,2);
            $UserRequest->save();
            if($request->has('waypoints')){
                Waypoint::create([
                    'request_id' => $UserRequest->id,
                    'coordinates' => $request->waypoints,
                ]);
            }

            $UserRequest->invoice = $this->invoice($id);

            return response()->json([
                'message' => 'You have Dropped the Customer',
                'request_id' => $UserRequest->id,
            ]);
           
        }catch (Exception $e){
            //return $e;
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }
    public function invoice($request_id)
    {
        try {

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
            }

            $UserRequest = UserRequest::findOrFail($request_id);
            $Points = Waypoint::where('request_id', $UserRequest->id)->first();
            $meter = 0;
            $seconds = 0;
            $route_key ='';

            $startTime = $UserRequest->started_at;
            $finishTime = $UserRequest->finished_at;
            $minutes = $finishTime->diffInMinutes($startTime);


            $current = Carbon::now()->toTimeString();
            $currentday = Carbon::now()->format('l');
            $fare_base=0.00;
            $fare_distance=0.00;
            $fare_minute=0.00;
            $fare_waiting=0.00;
            $distance_fare=0.00;
            $min_fare=0.00;
            $waiting_fare=0.00;
            $vat_fare=0.00;
            $Discount=0.00;
            $Commision = 0.00;
            $base_fare=0.00;
            $flat_fare=0.00;

            $discount_type ="flat";

            $waiting_time = strtotime("1970-01-01 $UserRequest->waiting_time UTC");
            $stop_waiting_time = strtotime("1970-01-01 $UserRequest->stop_waiting_time UTC");
            $waiting_time = $waiting_time / 60;
            $stop_waiting_time=$stop_waiting_time/60;

            $commission_enable = Setting::get('commission_enable', 0);
            $commission_percentage = Setting::get('commission_percentage', 0);
            $refer_enable = Setting::get('refferal', 0);
            $refer_type = Setting::get('refferal_type', "first ride");
            $refferal_value = Setting::get('refferal_value', 1);
            $first_ride=User::where('id',$UserRequest->user_id)->first();
            if($PromocodeUsage = PromocodeUsage::where('user_id', '=', $UserRequest->user_id)->where('status','ADDED')->first()){
                if($Promocode = Promocode::find($PromocodeUsage->promocode_id)){

                    $discount_type = $Promocode->discount_type;
                    $Discount = $Promocode->discount;
                    $PromocodeUsage->status ='USED';
                    $PromocodeUsage->save();
                }
            }

            $service_category_id=0;
            if($UserRequest->service_category_id!="")
            {
                $service_category_id=$UserRequest->service_category_id;
            }
            $service_type =  ServiceType::where('id',$UserRequest->service_type_id)->first();

            if($service_type->home_screen_id == 9 )
            {
                $fare_model = FareModel::where('service_type_id','=',$UserRequest->service_type_id)->first();
               
                $UserRequest->estimated_fare = round($fare_model->service_fare,2);
                // $fare_base =round($fare_mode->service_fare,2);
                // $base_fare =round($fare_mode->service_fare,2);
                $check_type =1;
                $flat_fare= round($fare_model->service_fare,2);
                $free_wait_time= 0 ;
                $free_stop_time= 0 ;
                $stop_waiting_fare = 0;
               // $distance_fare =round(0,2);
              
                
            }else{
                $fare_calc = app(\App\Http\Controllers\UserApiController::class)->fare_calc($service_category_id,$UserRequest->service_type_id, $UserRequest->s_latitude, $UserRequest->s_longitude, $UserRequest->d_latitude, $UserRequest->d_longitude,$UserRequest->distance, $minutes);
                $UserRequest->estimated_fare = round($fare_calc['fare_base'],2);
                $fare_base =round($fare_calc['fare_base'],2);
                $base_fare =round($fare_calc['fare_base'],2);
                $check_type =$fare_calc['check_type'];
                $flat_fare= round($fare_calc['fare_flat'],2);
                $distance_fare =round($fare_calc['distance_fare'],2);
                $min_fare=round($fare_calc['min_fare'],2);
                $free_wait_time=$fare_calc['fare_trip_waiting'];
                $free_stop_time=$fare_calc['fare_stop_waiting'];

                if($UserRequest->waiting_time){
                    if($free_wait_time < $waiting_time){
                        $waiting_time = $waiting_time - $free_wait_time;
                    }
                }
                if($UserRequest->stop_waiting_time){
                    if($free_stop_time < $stop_waiting_time){
                        $stop_waiting_time =$stop_waiting_time - $free_stop_time;
                    }
                }
    
    
                $fare_waiting=round($fare_calc['fare_waiting'],2);
                $waiting_fare = round($fare_waiting * $waiting_time,2);
                $stop_waiting=round($fare_calc['stop_waiting'],2);
                $stop_waiting_fare = round($stop_waiting * $stop_waiting_time,2);
    

            }

           

           
            if($UserRequest->stop1_address !=null || $UserRequest->stop2_address !=null){
               $fare_base=$fare_base+$distance_fare+$waiting_fare+$min_fare+$stop_waiting_fare;
               $flat_fare=0.00;
                $fare_type =3;
            }
            else{
            if($check_type==0){
               $flat_fare=0.00;
                $fare_type =3;
                $fare_base=$fare_base+$distance_fare+$waiting_fare+$min_fare+$stop_waiting_fare;
            }
            else{
                $distance_fare=0.00;
                $fare_base=$flat_fare+$distance_fare+$waiting_fare+$min_fare+$stop_waiting_fare;
                $base_fare=0.00;
                $fare_type =2;
              }
            }


            $service_type = ServiceType::where('id','=',$UserRequest->service_type_id)->first();

            if(Setting::get('vat_percent') !=0){
                $vat_fare = $fare_base * Setting::get('vat_percent')/100;
            }

            if($vat_fare < 0){
                $vat_fare = 0.00; // prevent from negative value
            }
            
            if($UserRequest->fare_type ==3){

                if($discount_type=="flat")
                {
                    $Total = $fare_base + $vat_fare  - $Discount;
                }else{
                    $dis_type= ($fare_base + $vat_fare)* $Discount / 100; 
                    $Total =$fare_base + $vat_fare - $dis_type;
                }

                
                $fare_base = $fare_base;
            }else{

                if($discount_type=="flat")
                {
                    $Total = $fare_base  - $Discount;
                }else{
                    $dis_type=$fare_base * $Discount / 100; 

                    $Total = $fare_base - $dis_type;
                }

                
                $fare_base = $fare_base - $vat_fare;
            }
            

            if($UserRequest->payment_mode == 'CASH') {
                $Total = ceil($Total);
            }
            if($fare_base < 0){
                $fare_base = 0.00; // prevent from negative value
            }
            if($Total < 0){
                $Total = 0.00; // prevent from negative value
            }
           
            if($commission_enable ==1){
                $total_amount = $fare_base;
                $Commision = $total_amount * $commission_percentage/100;
                $earnings=$total_amount-$Commision;
                $revenue=$total_amount-$Commision;
            }
            else{
                $total_amount = $fare_base;
                $Commision = 0;
                $earnings=$total_amount;
                $revenue=$total_amount;
            }
            if($UserRequest->booking_by == 'APP'){
            if($first_ride->refferal_by !=null){
             if($refer_enable==1){
                if($refer_type=="first ride"){
                    $Discount = $Total;
                    $Total=0.00;
                }
                else{
                    $Discount = $Total * $Total/$refferal_value;
                    $Total=$Total-$Discount;
                }
             }
            }
            }
            $Payment = new UserRequestPayment;
            $Payment->request_id = $UserRequest->id;
            $Payment->currency = Setting::get('currency');
            $Payment->base_fare = $base_fare;
            $Payment->flat_fare = $flat_fare;
            $Payment->distance_fare = $distance_fare;
            $Payment->commision = $Commision;
            $Payment->earnings = $earnings;
            $Payment->revenue = $revenue;
            $Payment->min_fare = $min_fare;
            $Payment->waiting_fare = $waiting_fare;
            $Payment->stop_waiting_fare = $stop_waiting_fare;
            $Payment->vat = $vat_fare;
            $Payment->payment_mode = $UserRequest->payment_mode;
            $Payment->discount = $Discount;
            $Payment->tip_fare = 0;
            $Payment->cash = abs($Total);
            $Payment->total = abs($Total);
            $Payment->save();

            $UserRequest->estimated_fare =abs($Total);
            $UserRequest->status = "DROPPED";
            // $UserRequest->distance = $kilometer;
            $UserRequest->fare_type=$fare_type;
            $UserRequest->minutes = $minutes;
            $UserRequest->route_key = $route_key;
            $UserRequest->save();

            if($UserRequest->booking_by == 'APP'){
                if($first_ride->refferal_by !=null){
                $first_ride->refferal_by=null;
                $first_ride->save();
            }
        }   

         if($UserRequest->payment_mode == 'CASH') {

        $wallet = Provider::find(Auth::user()->id);
        $wallet->wallet_balance -= $Commision;
        $wallet->save();
        ProviderWallet::create([
        'provider_id' => Auth::user()->id,
        'trip_id' =>$UserRequest->id,
        'amount' => $Commision,
        'mode' => 'Debited by Trips',
        'status' => 'Debited',
        ]);

         }else{

        $wallet = Provider::find(Auth::user()->id);
        $wallet->wallet_balance += $earnings;
        $wallet->save();
        ProviderWallet::create([
        'provider_id' => Auth::user()->id,
        'trip_id' =>$UserRequest->id,
        'amount' => $earnings,
        'mode' => 'Added by Trips',
        'status' => 'Credited',
        ]);
    }  
            return $Payment;
            
        } catch (ModelNotFoundException $e) {
            return false;
        }
    }
    public function additional_fare(Request $request)
    {
        $this->validate($request, [
                'request_id' => 'required|integer|exists:user_requests,id',
            ]);

        try {
            $UserRequest = UserRequest::findOrFail($request->request_id);
            $commission_enable = Setting::get('commission_enable', 0);
            $commission_percentage = Setting::get('commission_percentage', 0);

            if($UserRequest->status =='DROPPED'){
                $Payment = UserRequestPayment::where('request_id',$request->request_id)->first();
                $total = $Payment->total;
                if($request->has('toll_fee')){
                    if($Payment->toll ==0.00){
                        $Payment->toll = $request->toll_fee;
                        $Payment->total = $total + $request->toll_fee;  
                    }else{
                        $app_fare = $total - $Payment->toll;
                        $Payment->toll = $request->toll_fee;
                        $Payment->total = $app_fare + $request->toll_fee;
                    }  
                }
                if($request->has('extra_fee')){
                    if($Payment->extra_fare ==0.00){
                        $Payment->extra_fare = $request->extra_fee;
                        //$Payment->total = $total + $request->extra_fee;
                        $total_amount=$request->extra_fee;

                        if($commission_enable ==1){
                            $Commision = $total_amount * $commission_percentage/100;
                            $earnings=$total_amount-$Commision;
                        }
                        else{
                            $Commision = 0;
                            $earnings=0;
                        }

                        $Payment->total = $total_amount;
                        $Payment->base_fare = $total_amount;
                        $Payment->extra_fare = 0;
                        $Payment->commision = $Commision;
                        $Payment->earnings = $earnings;
                        $UserRequest->estimated_fare =$total_amount;
                    }else{

                        //$app_fare = $total - $Payment->extra_fare;
                        $app_fare = $total;
                        $Payment->extra_fare = $request->extra_fee;
                        //$Payment->total = $app_fare + $request->extra_fee;

                        $total_amount=$request->extra_fee;
                        if($commission_enable ==1){
                            $Commision = $total_amount * $commission_percentage/100;
                            $earnings=$total_amount-$Commision;
                        }
                        else{
                            $Commision = 0;
                            $earnings=0;
                        }

                        $Payment->total = $total_amount;
                        $Payment->base_fare = $total_amount;
                        $Payment->extra_fare = 0;
                        $Payment->commision = $Commision;
                        $Payment->earnings = $earnings;
                        $UserRequest->estimated_fare =$total_amount;
                    }
                    if($request->has('extra_desc')){
                        $Payment->extra_desc = $request->extra_desc;
                    }

                    $wallet = Provider::find(Auth::user()->id);
                    $wallet->wallet_balance += $earnings;
                    $wallet->save();

                    ProviderWallet::where('provider_id','=',Auth::user()->id)->where('trip_id','=',$UserRequest->id)->update(['amount' => $earnings, 'mode' => 'Added by Trips','status' => 'Credited']);

                    // ProviderWallet::create([
                    // 'provider_id' => Auth::user()->id,
                    // 'trip_id' =>$UserRequest->id,
                    // 'amount' => $earnings,
                    // 'mode' => 'Added by Trips',
                    // 'status' => 'Credited',
                    // ]);
                }
    
                $Payment->save();
                $UserRequest->save();
                return response()->json(['message' => 'Added successfully', 'success' =>1]);
            }
        }catch (Exception $e){
            return response()->json(['message' => trans('api.something_went_wrong'),'success' =>0]);
        }

    }

    public function payment_update(Request $request)
    {
        $this->validate($request, [
                'request_id' => 'required|integer|exists:user_requests,id',
            ]);

        try {
            $UserRequest = UserRequest::findOrFail($request->request_id);
            if($UserRequest->status =='DROPPED'){
                $UserRequest->payment_update =1;
                $UserRequest->save();
                return response()->json(['message' => 'status updated', 'success' =>1]);
            }
        }catch (Exception $e){
            return response()->json(['message' => trans('api.something_went_wrong'),'success' =>0]);
        }

    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function dropped_detail(Request $request)
    {
        try {
            $UserRequests = UserRequest::with('user','service_type','payment')->where('user_requests.status', '=', 'DROPPED')
            ->where('provider_id', '=', Auth::user()->id)
            ->orderBy('created_at','desc')
            ->first();
            $UserRequests->payment->trip_date =date('d-M-Y', strtotime($UserRequests->updated_at));

            return $UserRequests;

        }catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response 
     */
    public function rate(Request $request, $id)
    {

        $this->validate($request, [
                'rating' => 'required',
                'comment' => 'max:255',
            ]); 
    
        try {

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
            }

            $UserRequest = UserRequest::where('id', $id)
                ->firstOrFail();
            if($UserRequest->rating == null) {
                UserRequestRating::create([
                        'provider_id' => $UserRequest->provider_id,
                        'user_id' => $UserRequest->user_id,
                        'request_id' => $UserRequest->id,
                        'provider_rating' => $request->rating,
                        'provider_comment' => $request->comment ? : '',
                    ]);
            }else {
                $UserRequest->rating->update([
                        'provider_rating' => $request->rating,
                        'provider_comment' => $request->comment ? : '',
                    ]);
            }

            $UserRequest->update(['provider_rated' => $request->rating]);

            Provider::where('id',Auth::user()->id)->update(['trip_id' => 0, 'status' =>'active', 'active_from' =>Carbon::now()]);
            // Send Push Notification to Provider 
            $average = UserRequestRating::where('provider_id', $UserRequest->provider_id)->avg('provider_rating');
            if($UserRequest->user !=null){
                $UserRequest->user->update(['rating' => $average]);
            }
            
            return response()->json(['message' => 'Request Completed!']);

        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'Request not yet completed!'], 500);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function end_trips(Request $request, $id)
    {
        try {

            $UserRequest = UserRequest::with('user','service_type','payment')->findOrFail($id);

            if($UserRequest->corporate_id !=0){
                $UserRequest->status = 'COMPLETED';
                $UserRequest->paid = 1;
                $UserRequest->save();
                // (new SendPushNotification)->Completed($UserRequest);
                return response()->json([
                    'data' => $UserRequest,
                ]);
            }

            if($UserRequest->payment_mode == 'CASH'){
                $UserRequest->paid = 1;
            }
            if($UserRequest->payment_mode == 'CARD'){
               app(\App\Http\Controllers\PaymentController::class)->trip_payment($id,$UserRequest->user->id);
            }

             if($UserRequest->payment_mode == 'WALLET'){
                        $User = User::find($UserRequest->user_id);
                        $Wallet = $User->wallet_balance; 
                        $Total =$UserRequest->payment->total;
                        $WalletBalance = $Wallet-$Total; 
                        User::where('id',$UserRequest->user_id)->update(['wallet_balance' => $WalletBalance]);
                    }
            $UserRequest->paid = 1;
            $UserRequest->status = 'COMPLETED';
            $UserRequest->save();

            if($UserRequest->booking_by == 'STREET'){
            Provider::where('id',Auth::user()->id)->update(['trip_id' => 0, 'status' =>'active', 'active_from' =>Carbon::now()]);
            }

           // (new SendPushNotification)->Completed($UserRequest);

            return response()->json([
                'data' => $UserRequest,
            ]);
           
        }catch (Exception $e){
            return response()->json(['error' => $e]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function end_detail(Request $request)
    {
        try {
            $UserRequests = UserRequest::with('user','service_type','payment')->where('user_requests.status', '=', 'COMPLETED')
            ->where('user_requests.id', '=', Auth::user()->trip_id)
            ->first();
            

            return $UserRequests;

        }catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }


        public function test(){
    
        try{

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
            }
            
            $UserRequests = UserRequest::whereIn('status',['SEARCHING','SCHEDULED'])
                    ->where('provider_id','=', 0)
                    ->where('service_type_id','=', '1');

            if(Auth::user()->admin_id !=null){
                $UserRequests->where('admin_id','=',Auth::user()->admin_id);
            }        

            $UserRequests =  $UserRequests->where(function($q) {
                        $q->where('schedule_at', '<', Carbon::now()->addHour(Setting::get('feature_time')))
                          ->orWhereNull('schedule_at');
                    })
                    ->select('id','created_at','booking_id','service_type_id','s_address','d_address','distance','schedule_at','assigned_at','status','s_latitude','s_longitude','d_latitude','d_longitude')
                    ->orderBy('created_at','desc')
                    ->get();
            $data =[];
            //dd($UserRequests);

            if(Setting::get('dispatch_algorithm') ==1){
                $provider =Provider::where('id',Auth::user()->id)->select('id','latitude','longitude')->first();
                foreach($UserRequests as $key=>$UserRequest){
                    $service = ServiceType::where('id',$UserRequest->service_type_id)->select('name','image')->first();
                    $UserRequests[$key]->service_name = $service->name;
                    $UserRequests[$key]->service_image = $service->image;
                    $start = Carbon::parse($UserRequest->assigned_at);
                    $now = Carbon::now();
                    $seconds = $now->diffInSeconds($start);
                    //dd($seconds);
                    if($seconds <= Setting::get('time_1', '10')){
                        $distance = Setting::get('distance_1', '500')/1000;
                        $latitude = $UserRequest->s_latitude;
                        $longitude = $UserRequest->s_longitude;
                        //dd($latitude);
                        $Providers = Provider::where('account_status', 'approved')
                            ->where('status', 'active')
                            ->selectRaw("id , (1.609344 * 3956 * acos( cos( radians('$latitude') ) * cos( radians(latitude) ) * cos( radians(longitude) - radians('$longitude') ) + sin( radians('$latitude') ) * sin( radians(latitude) ) ) ) AS distance")
                            ->having('distance', '<=', $distance)
                            ->orderBy('active_from', 'asc')
                            ->get()
                            ->pluck('id')->toArray();
                        if(count($Providers) >0){
                            if($provider->id = $Providers[0])
                            {
                                $data[]=$UserRequest;
                            }
                        }

                    }else{
                        $distance = Helper::distance($UserRequest->s_latitude, $UserRequest->s_longitude, $provider->latitude, $provider->longitude, "K");
                        if($seconds > Setting::get('time_1', '10') && $seconds < Setting::get('time_2', '20')){
                            $distance = $distance*1000;
                            if($distance <= Setting::get('distance_1', '500')){
                                $data[]=$UserRequest;
                            }
                        }else if($seconds > Setting::get('time_2', '20') && $seconds < Setting::get('time_3', '30')){
                            if($distance <=Setting::get('distance_2', '1')){
                                $data[]=$UserRequest;
                            }
                        }else if($seconds > Setting::get('time_3', '30') && $seconds < Setting::get('time_4', '40')){
                            if($distance <=Setting::get('distance_3', '2')){
                               $data[]=$UserRequest;     
                            }
                        }else if($seconds > Setting::get('time_4', '40') && $seconds < Setting::get('time_5', '50')){
                            if($distance <=Setting::get('distance_4', '3')){
                                $data[]=$UserRequest;
                            }
                        }else if($seconds > Setting::get('time_5', '50') && $seconds < Setting::get('time_6', '60')){
                            if($distance <=Setting::get('distance_5', '4')){
                                $data[]=$UserRequest;
                            }
                        }else if($seconds > Setting::get('time_6', '60')){
                                $data[]=$UserRequest;
                        }else{

                        }
                    }
                }
            }else{
                foreach($UserRequests as $key=>$UserRequest){
                    $service = ServiceType::where('id',$UserRequest->service_type_id)->select('name','image')->first();
                    $UserRequests[$key]->service_name = $service->name;
                    $UserRequests[$key]->service_image = $service->image;
                    $data[]=$UserRequest;
                }
            }
            $now = Carbon::now()->addMinutes(60);
            if(count($data) > 0){
                foreach($data as $key => $UserRequest){
                    if($UserRequest->schedule_at !=null){
                        $locations = Location::select('tlatitude','tlongitude','location_name')->get();
                        foreach ($locations as $location) {
                            $vertices_y = array_filter(explode(',', $location->tlatitude));
                            $vertices_x = array_filter(explode(',', $location->tlongitude));
                            $points_polygon = count($vertices_x);

                            $latitude_y = $UserRequest->s_latitude;
                            $longitude_x = $UserRequest->s_longitude;
                            if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                                $data[$key]->s_address = $location->location_name;
                            }

                            $latitude_y = $UserRequest->d_latitude;
                            $longitude_x = $UserRequest->d_longitude;
                            if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                                $data[$key]->d_address = $location->location_name;
                            }
                        }
                    }
                }
            }
            return response()->json(['data' => $data, 'success' =>1]);
        }
        catch (Exception $e){
            return  response()->json(['error' => trans('api.something_went_wrong'), 'success' =>0], 500);
        }
    }

    public function summary(Request $request)
    {   

    try{
        Carbon::setWeekStartsAt(Carbon::SUNDAY);
        $type = $request->type;
        if($type ==0){
            $rides = UserRequest::where('provider_id', Auth::user()->id)->where('created_at', '>=', Carbon::today())->count();
             $revenue=   UserRequestPayment::whereHas('request', function($query) use ($request) {
                                        $query->where('provider_id', Auth::user()->id)->where('created_at', '>=', Carbon::today());
                                    })
                                ->sum('revenue');
            // $revenue = $total;
            $cancel_rides = UserRequest::where('status','CANCELLED')->where('provider_id', Auth::user()->id)->where('created_at', '>=', Carbon::today())->count();
            $scheduled_rides = UserRequest::where('trip_status','scheduled')->where('provider_id', Auth::user()->id)->where('created_at', '>=', Carbon::today())->count();
        }elseif($type ==1){
            $rides = UserRequest::where('provider_id', Auth::user()->id)->whereBetween('created_at', [Carbon::now()->startOfWeek(),Carbon::now()->endOfWeek()])->count();
            $revenue = UserRequestPayment::whereHas('request', function($query) use ($request) {
                        $query->where('provider_id', Auth::user()->id)->whereBetween('created_at', [Carbon::now()->startOfWeek(),Carbon::now()->endOfWeek()]);
                    })
             ->sum('revenue');
            // $revenue = $total;
            $cancel_rides = UserRequest::where('status','CANCELLED')->where('provider_id', Auth::user()->id)->whereBetween('created_at', [Carbon::now()->startOfWeek(),Carbon::now()->endOfWeek()])->count();
            $scheduled_rides = UserRequest::where('trip_status','scheduled')->where('provider_id', Auth::user()->id)->whereBetween('created_at', [Carbon::now()->startOfWeek(),Carbon::now()->endOfWeek()])->count();
        }elseif($type ==2){
            $rides = UserRequest::where('provider_id', Auth::user()->id)->whereMonth('created_at', Carbon::now()->month)->count();
            $revenue = UserRequestPayment::whereHas('request', function($query) use ($request) {
                        $query->where('provider_id', Auth::user()->id)->whereMonth('created_at', Carbon::now()->month);
                    })
                ->sum('revenue');
            // $revenue = $total;    
            $cancel_rides = UserRequest::where('status','CANCELLED')->where('provider_id', Auth::user()->id)->whereMonth('created_at', Carbon::now()->month)->count();
            $scheduled_rides = UserRequest::where('trip_status','scheduled')->where('provider_id', Auth::user()->id)->whereMonth('created_at', Carbon::now()->month)->count();
        }elseif($type ==3){
            $rides = UserRequest::where('provider_id', Auth::user()->id)->where('created_at', '>=', Carbon::now()->year)->count();
            $revenue = UserRequestPayment::whereHas('request', function($query) use ($request) {
                        $query->where('provider_id', Auth::user()->id)->where('created_at', '>=', Carbon::now()->year);
                    })
                ->sum('revenue');
            // $revenue = $total;
            $cancel_rides = UserRequest::where('status','CANCELLED')->where('provider_id', Auth::user()->id)->where('created_at', '>=', Carbon::now()->year)->count();
            $scheduled_rides = UserRequest::where('trip_status','scheduled')->where('provider_id', Auth::user()->id)->where('created_at', '>=', Carbon::now()->year)->count();
        }elseif($type ==4){
            $rides = UserRequest::where('provider_id', Auth::user()->id)->count();
            $revenue = UserRequestPayment::whereHas('request', function($query) use ($request) {
                        $query->where('provider_id', Auth::user()->id);
                    })
                ->sum('revenue');
            // $revenue = $total;
            $cancel_rides = UserRequest::where('status','CANCELLED')->where('provider_id', Auth::user()->id)->count();
            $scheduled_rides = UserRequest::where('trip_status','scheduled')->where('provider_id', Auth::user()->id)->count();
        }

            return response()->json([
                'rides' => $rides, 
                'revenue' => round($revenue,2),
                'cancel_rides' => $cancel_rides,
                'scheduled_rides' => $scheduled_rides,
            ]);
    }catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }


    public function earnings(Request $request)
    {
        try {

            Carbon::setWeekStartsAt(Carbon::SUNDAY);
            $type = $request->type;
            if($type==0){
                $earnings =
                    ProviderWallet::where('provider_id', Auth::user()->id)
                    ->where('created_at', '>=', Carbon::today())         
                   ->sum('amount');
                $kilometer = UserRequest::where('provider_id', Auth::user()->id)
                ->where('created_at', '>=', Carbon::today())         
                ->where('status', '=', 'COMPLETED')->sum('distance');
                $total_fare = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                    ->where('created_at', '>=', Carbon::today())         
                    ->sum('total');
                $commision = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                    ->where('created_at', '>=', Carbon::today())         
                    ->sum('commision');

                $extra_fare = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                    ->where('created_at', '>=', Carbon::today())         
                    ->sum('extra_fare');   
          }
            elseif($type==1){
                $earnings =ProviderWallet::where('provider_id', Auth::user()->id)
                    ->whereBetween('created_at', [Carbon::now()->startOfWeek(),Carbon::now()->endOfWeek()])   
                    ->sum('amount');
                $kilometer = UserRequest::where('provider_id', Auth::user()->id)
                ->whereBetween('created_at', [Carbon::now()->startOfWeek(),Carbon::now()->endOfWeek()])   
                ->where('status', '=', 'COMPLETED')->sum('distance');
                $total_fare = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                    ->whereBetween('created_at', [Carbon::now()->startOfWeek(),Carbon::now()->endOfWeek()])
                    ->sum('total');
                $commision = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                    ->whereBetween('created_at', [Carbon::now()->startOfWeek(),Carbon::now()->endOfWeek()])
                    ->sum('commision');

                $extra_fare = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                    ->whereBetween('created_at', [Carbon::now()->startOfWeek(),Carbon::now()->endOfWeek()])
                    ->sum('extra_fare');   
          }
            elseif($type==2){
                $earnings =ProviderWallet::where('provider_id', Auth::user()->id)
                        ->whereMonth('created_at', Carbon::now()->month)
                        ->sum('amount');
                $kilometer = UserRequest::where('provider_id', Auth::user()->id)
                ->whereMonth('created_at', Carbon::now()->month)
                ->where('status', '=', 'COMPLETED')->sum('distance');
                $total_fare = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                        ->whereMonth('created_at', Carbon::now()->month)
                       ->sum('total');
                $commision = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                        ->whereMonth('created_at', Carbon::now()->month)
                        ->sum('commision');

                $extra_fare = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                        ->whereMonth('created_at', Carbon::now()->month)
                      ->sum('extra_fare');   
          }

            elseif($type==3){
                $earnings =ProviderWallet::where('provider_id', Auth::user()->id)
                    ->where('created_at', '>=', Carbon::now()->year)
                    ->sum('amount');
                $kilometer = UserRequest::where('provider_id', Auth::user()->id)
                    ->where('created_at', '>=', Carbon::now()->year)
                ->where('status', '=', 'COMPLETED')->sum('distance');
                $total_fare = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                    ->where('created_at', '>=', Carbon::now()->year)
                    ->sum('total');
                $commision = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                    ->where('created_at', '>=', Carbon::now()->year)
                    ->sum('commision');

                $extra_fare = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                    ->where('created_at', '>=', Carbon::now()->year)
                    ->sum('extra_fare');   
          }            
          elseif($type==4){
                $earnings =ProviderWallet::where('provider_id', Auth::user()->id) 
                    ->sum('amount');
                $kilometer = UserRequest::where('provider_id', Auth::user()->id)->where('status', '=', 'COMPLETED')->sum('distance');
                $total_fare = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                    ->sum('total');
                $commision = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                    ->sum('commision');

                $extra_fare = UserRequestPayment::whereHas('request', function($query) use ($request) {
                            $query->where('provider_id', Auth::user()->id);
                        })
                    ->sum('extra_fare');   
          }
                $provider =Provider::where('id',Auth::user()->id)->first();

            return response()->json([
                'earnings' =>round($provider->wallet_balance,2), 
                'kilometer' => round($kilometer,2),
                'total_fare'=>round($total_fare,2),
                'commision' => round($commision,2), 
                'extra_fare' => round($extra_fare,2) 
            ]);
        }catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    public function earning_details(Request $request)
    {
        try {
            Carbon::setWeekStartsAt(Carbon::SUNDAY);
            $type = $request->type;

            if($type==0){
            $earnings = UserRequestPayment::whereHas('request', function($query) use ($request) {
                        $query->where('provider_id', Auth::user()->id);
                    })
                ->where('created_at', '>=', Carbon::today())
                ->orderBy('created_at','desc')
                ->get();
            if(count($earnings) > 0){
                foreach($earnings as $earning) {
                    $userRequest = UserRequest::where('id',$earning->request_id)->first();
                    $dataArray[] = [
                    'id' => $earning->id,
                    'date' =>$userRequest->created_at,
                    'distance'=>$userRequest->distance,
                    'trip_fare' =>round($earning->total,2),
                    'commision' => round($earning->commision,2),
                    'earnings' => round($earning->earnings,2),
                    'tip' => round($earning->tip_fare,2)
                    ];    
                }
                return response()->json([
                    'earnings' => $dataArray, 
                ]);
            }
            }
            elseif($type==1){
            $earnings = UserRequestPayment::whereHas('request', function($query) use ($request) {
                        $query->where('provider_id', Auth::user()->id);
                    })
                ->whereBetween('created_at', [Carbon::now()->startOfWeek(),Carbon::now()->endOfWeek()])       
                ->orderBy('created_at','desc')
                ->get();
                if(count($earnings) > 0){
                    foreach($earnings as $earning) {
                        $userRequest = UserRequest::where('id',$earning->request_id)->first();
                        $dataArray[] = [
                        'id' => $earning->id,
                        'date' =>$userRequest->created_at,
                        'distance'=>$userRequest->distance,
                        'trip_fare' =>round($earning->total,2),
                        'commision' => round($earning->commision,2),
                        'earnings' => round($earning->earnings,2),
                        'tip' => round($earning->tip_fare,2)
                        ];    
                }
                return response()->json([
                    'earnings' => $dataArray, 
                ]);
                }
            }
            elseif($type==2){
            $earnings = UserRequestPayment::whereHas('request', function($query) use ($request) {
                        $query->where('provider_id', Auth::user()->id);
                    })
                ->whereMonth('created_at', Carbon::now()->month)
                ->orderBy('created_at','desc')
                ->get();
            if(count($earnings) > 0){
                foreach($earnings as $earning) {
                    $userRequest = UserRequest::where('id',$earning->request_id)->first();
                    $dataArray[] = [
                    'id' => $earning->id,
                    'date' =>$userRequest->created_at,
                    'distance'=>$userRequest->distance,
                    'trip_fare' =>round($earning->total,2),
                    'commision' => round($earning->commision,2),
                    'earnings' => round($earning->earnings,2),
                    'tip' => round($earning->tip_fare,2)
                    ];    
                }
                return response()->json([
                    'earnings' => $dataArray, 
                ]);
            }
            }
        elseif($type==3){
            $earnings = UserRequestPayment::whereHas('request', function($query) use ($request) {
                        $query->where('provider_id', Auth::user()->id);
                    })
                    ->whereBetween('created_at', [Carbon::now()->startOfYear(),Carbon::now()->endOfYear(),])
                    ->orderBy('created_at','desc')
                    ->get();
            if(count($earnings) > 0){
                foreach($earnings as $earning) {
                    $userRequest = UserRequest::where('id',$earning->request_id)->first();
                    $dataArray[] = [
                    'id' => $earning->id,
                    'date' =>$userRequest->created_at,
                    'distance'=>$userRequest->distance,
                    'trip_fare' =>round($earning->total,2),
                    'commision' => round($earning->commision,2),
                    'earnings' => round($earning->earnings,2),
                    'tip' => round($earning->tip_fare,2)
                    ];    
                }
                return response()->json([
                    'earnings' => $dataArray, 
                ]);
            }
            }
        elseif($type==4){
            $earnings = UserRequestPayment::whereHas('request', function($query) use ($request) {
                        $query->where('provider_id', Auth::user()->id);
                    })
                ->orderBy('created_at','desc')
                ->get();
            if(count($earnings) > 0){
                foreach($earnings as $earning) {
                    $userRequest = UserRequest::where('id',$earning->request_id)->first();
                    $dataArray[] = [
                    'id' => $earning->id,
                    'date' =>$userRequest->created_at,
                    'distance'=>$userRequest->distance,
                    'trip_fare' =>round($earning->total,2),
                    'commision' => round($earning->commision,2),
                    'earnings' => round($earning->earnings,2),
                    'tip' => round($earning->tip_fare,2)
                    ];    
                }
                return response()->json([
                    'earnings' => $dataArray, 
                ]);
            }
            }
            return response()->json([
                'earnings' => null, 
            ]);
        }catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    public function all_trips(Request $request) {
        try{

            $data = array();
            Carbon::setWeekStartsAt(Carbon::SUNDAY);
            $type = $request->type;
            if($type==0){
            $UserRequests = UserRequest::where('provider_id', '=', Auth::user()->id)
                    // ->whereIn('user_requests.status', ['COMPLETED', 'CANCELLED'])
                    ->join('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
                    // ->join('user_request_payments', 'user_requests.id', '=', 'user_request_payments.request_id')
                    ->select('user_requests.id','user_requests.booking_id','user_requests.user_id','service_types.name','user_requests.status','user_requests.s_address','user_requests.d_address','user_requests.stop1_address','user_requests.stop2_address','user_requests.distance','user_requests.minutes','user_requests.corporate_id','finished_at','user_requests.created_at')
                    ->where('user_requests.created_at', '>=', Carbon::today())
                    ->orderBy('user_requests.created_at','desc')
                    ->get();

            }
            elseif($type==1){
            $UserRequests = UserRequest::where('provider_id', '=', Auth::user()->id)
                    ->join('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
                    ->select('user_requests.id','user_requests.booking_id','user_requests.user_id','service_types.name','user_requests.status','user_requests.s_address','user_requests.d_address','user_requests.stop1_address','user_requests.stop2_address','user_requests.distance','user_requests.minutes','user_requests.corporate_id','finished_at','user_requests.created_at')
                    ->whereBetween('user_requests.created_at', [Carbon::now()->startOfWeek(),Carbon::now()->endOfWeek()])
                    ->orderBy('user_requests.created_at','desc')
                    ->get();
            }

            elseif($type==2){
            $UserRequests = UserRequest::where('provider_id', '=', Auth::user()->id)
                    ->join('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
                    ->select('user_requests.id','user_requests.booking_id','user_requests.user_id','service_types.name','user_requests.status','user_requests.s_address','user_requests.d_address','user_requests.stop1_address','user_requests.stop2_address','user_requests.distance','user_requests.minutes','user_requests.corporate_id','finished_at','user_requests.created_at')
                    ->whereMonth('user_requests.created_at', Carbon::now()->month)
                    ->orderBy('user_requests.created_at','desc')
                    ->get();

            }
            elseif($type==3){
            $UserRequests = UserRequest::where('provider_id', '=', Auth::user()->id)
                    ->join('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
                    ->select('user_requests.id','user_requests.booking_id','user_requests.user_id','service_types.name','user_requests.status','user_requests.s_address','user_requests.d_address','user_requests.stop1_address','user_requests.stop2_address','user_requests.distance','user_requests.minutes','user_requests.corporate_id','finished_at','user_requests.created_at')
                    ->where('user_requests.created_at', '>=', Carbon::now()->year)
                    ->orderBy('user_requests.created_at','desc')
                    ->get();
            }
            elseif($type==4){
            $UserRequests = UserRequest::where('provider_id', '=', Auth::user()->id)
                    ->join('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
                    ->select('user_requests.id','user_requests.booking_id','user_requests.user_id','service_types.name','user_requests.status','user_requests.s_address','user_requests.d_address','user_requests.stop1_address','user_requests.stop2_address','user_requests.distance','user_requests.minutes','user_requests.corporate_id','finished_at','user_requests.created_at')
                    ->orderBy('user_requests.created_at','desc')
                    ->get();
            }
                foreach($UserRequests as $key=>$UserRequest){
                    $profile='';
                    if($UserRequest->user_id !=0 ){
                    $user_id=User::where('id',$UserRequest->user_id)->first();
                    if($user_id){
                      $profile=asset('storage/'. $user_id->picture);
                    }
                    else{
                      $profile='';
                    }
                    }
                    $data[] =[
                    'id' => $UserRequest->id,
                    'booking_id'=>$UserRequest->booking_id,
                    'name' => $UserRequest->name,
                    'status' => $UserRequest->status,
                    'picture' => $profile,
                    's_address' => $UserRequest->s_address,
                    'd_address' => $UserRequest->d_address,
                    'stop1_address' => $UserRequest->stop1_address,
                    'stop2_address' => $UserRequest->stop2_address,
                    'distance' => $UserRequest->distance,
                    'minutes' => $UserRequest->minutes,
                    'corporate_id' => $UserRequest->corporate_id,
                    'finished_at' =>date("Y-m-d h:i A", strtotime($UserRequest->finished_at)),
                    'created_at' =>date("Y-m-d h:i A", strtotime($UserRequest->created_at)) 
                    ];
                }

            return $data;
        }
        catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    public function pushNotification(Request $request)
    {
        try {
            $pushMsg = MemberNotification::where('person_id', Auth::user()->id)->where('member', '=','driver')->get();
            return response()->json(['pushMessage' => $pushMsg]);
        } catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }


    public function invoice_copy(Request $request){

        $this->validate($request, [
                'request_id' => 'required',
            ]);

        // try{
            $UserRequest = UserRequestPayment::where('request_id',$request->request_id)->first();
            $UserRequest->name=Auth::user()->name;
            if(Setting::get('mail_enable', 0) == 1) {

                Mail::send('emails.invoice-copy', ['UserRequest' => $UserRequest], function ($message) use ($UserRequest){
                    $message->to(Auth::user()->email, Auth::user()->name)->subject(config('app.name').' Invoice Copy');
                });

            }
                return response()->json(['success' => 1,'message'=>'Invoice copy sent to registered email']);

        // }catch (Exception $e) {
        //         return response()->json(['error' => trans('api.something_went_wrong')]);
        // }
    }


        public function testpushnotificationsss(Request $request){

        $data=  PushNotification::setService('fcm')
                        ->setMessage([
                            'priority' => 'high',
                            'notification' => [
                                     'title'=>config('app.name'),
                                     'body'=>'test',
                                    'sound' => 'alerttonee.mp3'
                                     ],
                             'data' => [
                                     'title'=>config('app.name'),
                                     'body'=>'test',
                                    'sound' => 'alerttonee.mp3'
                                     ]
                             ])
            ->setApikey('AAAAF-UbzJM:APA91bHM-w6YMF0EciRWXWmeA3aP_ipl6jSmGtCsXJmYUUOjvnMLMTVPfNnWHCZn0clq0Ti4bXm2k7PWPOm40cM3OncVcEamjpf9b6r0Lxzqu1HPBSVhDg4EiCYTr0VlAH3zTJ9G4NMn')
             ->setDevicesToken('e8oHFXJPBIc:APA91bHUxQOLwTq7esWFmwerywiOmX0_21miQqA5sAzjN2AFR8kSn96vgt9FtWfWmeR1H4dGIPdFySJ9DNxLJXzQfMMXtpnAg-mSyDTuX2A_rgnmfrdL1S2I308ETdhqm0mxbBHETcuM')
             ->send();  
        echo '<pre>';
        print_r($data);
        exit;

        }


    public function contact_list(Request $request){

        try{

            $Contacts = ContactList::where('user_id', Auth::user()->id)->where('type','provider')->get();
            return $Contacts;
            /*if($request->ajax()) {
                return response()->json([$Contacts]);
            }*/
        }catch (Exception $e) {
            if($request->ajax()) {
                return response()->json(['error' => 'Something went Wrong']);
            }
        }
    }
    /**
     * help Details.
     *
     * @return \Illuminate\Http\Response
     */

    public function add_contact(Request $request){

        $this->validate($request, [
                'contact_name' => 'required',
                'contact_number' => 'required',
            ]);

        try{
            $checklist = ContactList::where('user_id',Auth::user()->id)
                        ->where('type','provider')
                        ->where('contact_number',$request->contact_number)
                        ->get();
            if(count($checklist) ==0){
                $Contact = new ContactList;
                $Contact->user_id = Auth::user()->id;
                $Contact->contact_name = $request->contact_name;
                $Contact->contact_number = $request->contact_number;
                $Contact->type = 'provider';
                $Contact->save();
                if($request->ajax()) {
                    return response()->json([
                            'message' => 'Contact Added Successfully',
                            'contact_name' => $Contact->contact_name,
                            'contact_number' => $Contact->contact_number,
                            'success' =>1

                        ]);
                }
                else{
                    return response()->json([
                            'message' => 'Contact Added Successfully',
                            'contact_name' => $Contact->contact_name,
                            'contact_number' => $Contact->contact_number,
                            'success' =>1

                        ]);
                }
            }else{
                if($request->ajax()) {
                    return response()->json([
                            'message' => 'Contact Already Exists',
                            'success' =>1
                        ]);
                }
                else{
                    return response()->json([
                            'message' => 'Contact Already Exists',
                            'success' =>1
                        ]);
                }
            }

        }catch (Exception $e) {
            if($request->ajax()) {
                return response()->json(['error' => trans('api.something_went_wrong')],500);
            }
        }
    }

    /**
     * help Details.
     *
     * @return \Illuminate\Http\Response
     */

    public function delete_contact(Request $request){

        $this->validate($request, [
                'contact_number' => 'required',
            ]);

        try{

            $Contact = ContactList::where('user_id',Auth::user()->id)
                        ->where('type','provider')
                        ->where('contact_number',$request->contact_number)
                        ->delete();
            
            if($request->ajax()) {
                return response()->json([
                        'message' => "Contact Deleted"
                    ]);
            }
            else{
                return response()->json([
                        'message' => "Contact Deleted"
                    ]);
            }

        }catch (Exception $e) {
            if($request->ajax()) {
                return response()->json(['error' => trans('api.something_went_wrong')]);
            }
        }
    }

    public function clear_status(Request $request) {
        Provider::where('id','=',$request->provider_id)->update(['trip_id' => 0,'status' => 'active', 'active_from' =>Carbon::now()]);

        $UserRequest = UserRequest::findOrFail($request->request_id);
        if($UserRequest){
            $UserRequest->provider_id=0;
            $UserRequest->current_provider_id=0;
            $UserRequest->save();
        }
            return response()->json([
                'message' => 'Trip Cleared successfully',
                'success' =>1
            ]);
    }

}
