<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\URL;
use Mail;
use DB;
use Log;
use Auth;
use Hash;
use Storage;
use Setting;
use Exception;
use Notification;
use GuzzleHttp\Client;
use Carbon\Carbon;
use App\Notifications\ResetPasswordOTP;
use App\Helpers\Helper;
use Validator;
use App\Models\Complaint;
use App\Models\User;
use App\Models\Card;
use App\Models\Country;
use App\Models\ServiceType;
use App\Models\FareModel;
use App\Models\Promocode;
use App\Models\PromocodeUsage;
use App\Models\UserRequest;
use App\Models\Provider;
use App\Models\CorporateUser;
use App\Models\Corporate;
use App\Models\CorporateGroup;
use App\Models\UserRequestRating;
use App\Models\UserRequestPayment;
use App\Models\Location;
use App\Models\PoiFare;
use App\Models\LocationWiseFare;
use App\Models\RestrictLocation;
use App\Models\Token;
use App\Models\Admin;
use App\Models\MemberNotification;
use DateTimeZone;
use App\Models\RequestFilter;

class UserApiController extends Controller
{   

    // public function __construct()
    // {
    //     //$this->middleware('admin');

        
    //    //$this->middleware('dispatcher');
    //     $this->middleware(function ($request, $next) {
    //     $this->id = Auth::user()->id;
    //     //$this->email = Auth::user()->email;
    //     $this->admin_type = Auth::user()->admin_type;
    //     Auth::user()->admin_id = Auth::user()->admin_id;
    //     dd($this->id);
    //     if(Auth::user()->admin_id !=  null){
            
    //          $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
           
    //          if($admin->admin_type != 0 && $admin->time_zone != null){
    //              date_default_timezone_set($admin->time_zone);
                
    //          }
    //      }
            
    //     return $next($request);
    // });
        

    // }

    public function stripe_key(){
    
        $key = Setting::get('stripe_publishable_key');

        return response()->json(['publishable_key' => $key]);
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function signup(Request $request)
    {
        
        $validator = Validator::make($request->all(), [
            // 'social_unique_id' => ['required_if:login_by,facebook,google','unique:users'],
            'device_type' => 'required|in:android,ios',
            'device_token' => 'required',
            'device_id' => 'required',
            'login_by' => 'required|in:manual,facebook,google',
            'first_name' => 'required|max:255',
            'last_name' => 'required|max:255',
            'email' => 'required|email|max:255|unique:users',
            'dial_code' => 'required',
            'mobile' => 'required',
            'password' => 'required|min:6',
        ]);
        if($validator->fails()) { 
            return response()->json(['error'=>$validator->errors()], 401);            
        }

       try{
            $country = Country::where('dial_code','=',$request->dial_code)->first();
            $input = $request->all();
            $input['payment_mode'] = 'CASH';
            $input['password'] = bcrypt($request->password);
            if($country !=null){
                $input['country_id'] = $country->countryid;
            }
            $user = User::create($input);
            if($request->card_token){
                \Stripe\Stripe::setApiKey(Setting::get('stripe_secret_key'));
                $customer = \Stripe\Customer::create([
                            'email' => $user->email,
                             'card'=>$request->stripe_token,

                        ]);
                echo '<pre>';
                return  print_r($customer);
                exit;
                $strip_cust_id = $customer['id'];
                // $customer = \Stripe\Customer::retrieve($strip_cust_id);
             //   $card = $customer->sources->create(["source" => $request->stripe_token]);
                $create_card = new Card;
                $create_card->user_id = $user->id;
                $create_card->card_id = $customer->default_source;
                $create_card->last_four = $request->card_last4;
                $create_card->brand = $request->card_brand;
                $create_card->save();
                User::where('id',$user->id)->update(['stripe_cust_id' => $strip_cust_id]);
            }
            //$success['token'] =  $user->createToken('Personal Access Token')->accessToken;
            $success['message'] =  'You have Successfully registered with Unico taxi'; 
            $success['first_name'] =  $user->first_name;
            return response()->json(['success'=>$success], 200); 

        }catch (Exception $e) {
             return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }


    }
    /** 
     * login api 
     * 
     * @return \Illuminate\Http\Response 
     */ 
    public function login(Request $request){

        if(Auth::attempt(['email' => request('username'), 'password' => request('password')])){ 
            $user = Auth::user(); 

            $http = new \GuzzleHttp\Client();
            $response = $http->post('https://dev.unicotaxi.com/oauth/token', [
                'form_params' => [
                    'grant_type' => 'password',
                    'client_id' => $request->client_id,
                    'client_secret' => $request->client_secret,
                    'username' => $request->username,
                    'password'=>$request->password,
                    'scope' => '',
                ],
            ]);
            if($user){
                if($request->has('device_token')){
                    $user->device_token = $request->device_token;
                }

                if($request->has('device_type')){
                    $user->device_type = $request->device_type;
                }

                if($request->has('device_id')){
                    $user->device_id = $request->device_id;
                }
                $user->save();
            }

            return json_decode((string) $response->getBody(), true);
            // return response()->json(['success'=>$success], 200); 
            // return $success;
        } 
        else{ 
            return response()->json(['error'=>'Unauthorised'], 401); 
        } 
    }
    
    /** 
     * login api 
     * 
     * @return \Illuminate\Http\Response 
     */ 
    public function send_mobile(Request $request){

        // if(Auth::user()->admin_id !=  null){
        //     $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
        //     if($admin->admin_type != 0 && $admin->time_zone != null){
        //          date_default_timezone_set($admin->time_zone);
        //      }
        //  }

        $this->validate($request, [
            'mobile' => 'required',
            'dial_code' => 'required',
        ]);

        try {

            $User = User::where('mobile','=',$request->mobile)->first();
            if($User ==null){
                return response()->json(['success' => "Account details not found. Please contact Unicotaxi", "message"=>0], 200);
            }
            $token_user = Token::where('mobile','=',$request->mobile)->first();
            if($token_user !=null){
                //$otp = rand(pow(10, 4-1), pow(10, 4)-1);
                $otp = 1234;
                $token_user->code = $otp;
                $token_user->updated_at = Carbon::now();
                $token_user->save();

                $number = $token_user->dial_code.$token_user->mobile;
                $message = "<#> UnicoTaxi: Your verification code is ".$otp." PUJWhJxn7T+";
                //$message = "DO NOT SHARE:".$otp." is the OTP for your account. Keep this OTP to yourself for account safety.";
                (new SendPushNotification)->sendSMSUser($number,$message);

            }else{
                //$otp = rand(pow(10, 4-1), pow(10, 4)-1);
                $otp = 1234;
                Token::create([
                        'code' => $otp,
                        'user_id' =>null,
                        'mobile' => $request->mobile,
                        'dial_code' => $request->dial_code,
                        'used' => 0,
                    ]);
                $number = $request->dial_code.$request->mobile;
                $message = "<#> UnicoTaxi: Your verification code is ".$otp." PUJWhJxn7T+";
                //$message = "DO NOT SHARE:".$otp." is the OTP for your account. Keep this OTP to yourself for account safety.";
                (new SendPushNotification)->sendSMSUser($number,$message);
            }
            return response()->json(['success' => "OTP send Successfully", "message"=>1], 200); 
        } 
        catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }
    /** 
     * login api 
     * 
     * @return \Illuminate\Http\Response 
     */ 
    public function resend_otp(Request $request){

        $this->validate($request, [
            'mobile' => 'required',
        ]);

        try {
            $token_user = Token::where('mobile','=',$request->mobile)->first();
            if($token_user !=null){
                //$otp = rand(pow(10, 4-1), pow(10, 4)-1);
                $otp = 1234;
                $token_user->code = $otp;
                $token_user->updated_at = Carbon::now();
                $token_user->save();
                $number = $token_user->dial_code.$token_user->mobile;
                $message = "<#> UnicoTaxi: Your verification code is ".$otp." PUJWhJxn7T+";
                //$message = "DO NOT SHARE:".$otp." is the OTP for your account. Keep this OTP to yourself for account safety.";
                (new SendPushNotification)->sendSMSUser($number,$message);

                return response()->json(['success' => "OTP Re-send Successfully", "message"=>1], 200);
            }else{
                return response()->json(['success' => "Please try again", "message"=>0], 200);
            }
        }
        catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }
    /** 
     * login api 
     * 
     * @return \Illuminate\Http\Response 
     */ 
    public function otp_verify(Request $request){

        $this->validate($request, [
            'mobile' => 'required',
            'otp' => 'required',
        ]);

        // try {
            $checker = Token::where('mobile','=',$request->mobile)->first();
            $now = Carbon::now()->subMinutes(2);
            if($checker ==null){
               return response()->json(['success' => "Please try again", "message"=>0], 200); 
            }
            if($checker !=null  && $checker->updated_at < $now){
                return response()->json(['success' => "OTP Expired. Please try again", "message"=>0], 200);
            }
            $token_user = Token::where('code','=',$request->otp)
                        ->where('mobile','=',$request->mobile)
                        ->first();

            if($token_user !=null){
                $User = User::where('mobile','=',$token_user->mobile)->first();
                if($User){
                    if($request->has('device_token')){
                        $User->device_token = $request->device_token;
                    }

                    if($request->has('device_type')){
                        $User->device_type = $request->device_type;
                    }

                    if($request->has('device_id')){
                        $User->device_id = $request->device_id;
                    }
                    $User->save();
                    $userToken = $User->token()?:$User->createToken('otpLogin');
                    $token_user->delete();
                    return response()->json([
                            "status" => true,
                            "message"=>1,
                            "admin_id"=> $User->admin_id,
                            "token_type" => "Bearer",
                            "access_token" => $userToken->accessToken
                            ]);
                }else{
                    /*$country = Country::where('dial_code','=',$token_user->dial_code)->first();
                    $input = $request->all();
                    $input['name'] = 'User'.mt_rand(100000, 999999);
                    $input['email'] = '';
                    $input['login_by'] = 'manual';
                    $input['dial_code'] = $token_user->dial_code;
                    $input['mobile'] = $token_user->mobile;
                    $input['payment_mode'] = 'CASH';
                    $input['password'] = bcrypt('User'.mt_rand(100000, 999999));
                    if($country !=null){
                        $input['country_id'] = $country->countryid;
                    }
                    if($request->has('device_token')){
                        $input['device_token'] = $request->device_token;
                    }

                    if($request->has('device_type')){
                        $input['device_type'] = $request->device_type;
                    }

                    if($request->has('device_id')){
                        $input['device_id'] = $request->device_id;
                    }
                    $User = User::create($input);
                    $userToken = $User->token()?:$User->createToken('otpLogin');
                    $token_user->delete();
                    return response()->json([
                            "status" => true,
                            "message"=>1,
                            "token_type" => "Bearer",
                            "access_token" => $userToken->accessToken
                            ]);*/

                    return response()->json(['success' => "Account details not found. Please contact Unicotaxi", "message"=>0], 200);

                }
               
            }else{
                return response()->json(['success' => "OTP Not Matched", "message"=>0], 200);
            }
 
        // } 
        // catch (Exception $e) {
        //     return response()->json(['success' => trans('api.something_went_wrong'), "message"=>0], 200);
        // }
    }

    /**
     * Logout user (Revoke the token)
     *
     * @return [string] message
     */
    public function logout()
    {
        Auth::user()->token()->revoke();
        return response()->json([
            'success' => 'Successfully logged out'
        ]);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function change_password(Request $request){

        $this->validate($request, [
                'password' => 'required|min:6',
                'old_password' => 'required',
            ]);

        $User = Auth::user();
        if(Hash::check($request->old_password, $User->password))
        {
            $User->password = bcrypt($request->password);
            $User->save();
           return response()->json(['success' => "1", "message"=>trans('api.user.password_updated')], 200);
           
        } else {
            // return response()->json(['success' => "1", "message"=>trans('api.user.password_updated')], 200);
            return response()->json(['success' => "0", "message"=>trans('api.user.incorrect_password')], 500);
            // return response()->json(['error' => trans('api.user.incorrect_password')], 500);
        }

    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function details(Request $request){

        $this->validate($request, [
            'device_type' => 'in:android,ios',
        ]);

        try{

            if($user = User::find(Auth::user()->id)){

                if($request->has('device_token')){
                    $user->device_token = $request->device_token;
                }

                if($request->has('device_type')){
                    $user->device_type = $request->device_type;
                }

                if($request->has('device_id')){
                    $user->device_id = $request->device_id;
                }
                $user->save();

                if($user->corporate_user_id !=null && $user->corporate_user_id !=0){
                    $corporate_user = CorporateUser::where('id','=',$user->corporate_user_id)->first();

                    $user->corporate = Corporate::where('id','=',$corporate_user->corporate_id)->pluck('display_name')->first();
                    $corporate_ridedays = CorporateGroup::where('id','=',$corporate_user->corporate_group_id)->pluck('allowed_days')->first();
                    $user->corporate_ridedays = '';
                    $user->corporate_email = $corporate_user->emp_email;
                    $user->corporate_phone = $corporate_user->emp_phone;
                }
                $user->picture = asset('storage/'.$user->picture);
                return $user;

            } else {
                return response()->json(['error' => trans('api.user.user_not_found')], 500);
            }
        }
        catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }
    /**
     * help Details.
     *
     * @return \Illuminate\Http\Response
     */

    public function help_details(Request $request){

        try{

            if($request->ajax()) {
                return response()->json([
                    'contact_number' => Setting::get('contact_number',''), 
                    'contact_email' => Setting::get('contact_email',''),
                    'privacy' => url("/privacy"),
                    'terms' => url("/terms-conditions"),
                    'faq' => url("/faq"),
                    'website' => url("/"),
                     ]);
            }

        }catch (Exception $e) {
            if($request->ajax()) {
                return response()->json(['error' => trans('api.something_went_wrong')], 500);
            }
        }
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function update_profile(Request $request)
    {   
        if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }
        $validator = Validator::make($request->all(), [
            // 'first_name' => 'required|max:255',
            // 'last_name' => 'required|max:255',
            // 'email' => 'required',
            // 'dial_code' => 'required',
            // 'mobile' => 'required',
            // 'picture' => 'mimes:jpeg,bmp,png',
        ]);

        if($validator->fails()) {
            return response()->json(['error'=>$validator->errors()->first()], 422);
        }

         try {

            $user = User::findOrFail(Auth::user()->id);

            if($request->has('first_name')){ 
                $user->first_name = $request->first_name;
            }
    
            if($request->has('email')){
                $user->email = $request->email;
            }
        
            if($request->has('mobile')){
                $user->mobile = $request->mobile;
            }

            if($request->has('dial_code')){
                $user->dial_code = $request->dial_code;
            }

            if ($request->picture != "") {
                Storage::delete($user->picture);
                $user->picture = $request->picture->store('user/profile');
            }

            $user->save();
            return response()->json(['success'=>$user], 200);
            
        }
        catch (ModelNotFoundException $e) {
             return response()->json(['error' => trans('api.user.user_not_found')], 500);
        }

    }
    /**
     * Forgot Password.
     *
     * @return \Illuminate\Http\Response
     */


    public function forgot_password(Request $request){

        $this->validate($request, [
                'email' => 'required|email|exists:users,email',
            ]);

        try{  
            
            $user = User::where('email' , $request->email)->first();

            $otp = mt_rand(1000, 9999);

            $user->otp = $otp;
            $user->save();

            Notification::send($user, new ResetPasswordOTP($otp));
            /*//sms
            if(Setting::get('sms_enable', 0) == 1) {
                $mobile = $user->mobile;
                $message = 'Kindly note your OTP : '.$otp.' Regards '.config('app.name'); 
                    try {
                        Twilio::message($mobile, $message);
                    } catch ( \Services_Twilio_RestException $e ) {
                        //return $e->getMessage();  
                    }
            }*/
                
            return response()->json([
                'message' => 'OTP sent to your email!',
                'user' => $user
            ]);

        }catch(Exception $e){
                return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }
    /**
     * Reset Password.
     *
     * @return \Illuminate\Http\Response
     */

    public function reset_password(Request $request){

        $this->validate($request, [
                'password' => 'required|confirmed|min:6',
                'id' => 'required|numeric|exists:users,id'
            ]);

        try{

            $User = User::findOrFail($request->id);
            $User->password = bcrypt($request->password);
            $User->save();

            if($request->ajax()) {
                return response()->json(['message' => 'Password Updated']);
            }

        }catch (Exception $e) {
            if($request->ajax()) {
                return response()->json(['error' => trans('api.something_went_wrong')]);
            }
        }
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function country_list(Request $request){

        try{
            $countries = Country::all();
            return response()->json(['success'=>$countries], 200);
        }
        catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }

    /**
     * help Details.
     *
     * @return \Illuminate\Http\Response
     */

    public function complaint(Request $request){

        if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }

        $validator = Validator::make($request->all(), [
            'complaint_type' => 'required',
            'complaint_desc' => 'required',
        ]);

        if($validator->fails()) {
            return response()->json(['message'=>$validator->errors()->first(), 'success'=>0], 200);
        }

        try{
            $Complaint = new Complaint;
            $Complaint->name = Auth::user()->first_name;
            $Complaint->email = Auth::user()->email;
            $Complaint->phone = Auth::user()->mobile;
            
            $status = $request->complaint_type;
            switch ($status) {
                case "1":
                    $Complaint->complaint_type = "Driver behaviour";
                    break;
                case "2":
                    $Complaint->complaint_type = "Driver driving skills";
                    break;
                case "3":
                    $Complaint->complaint_type = "Lost property";
                    break;
                case "4":
                    $Complaint->complaint_type = "Trip charges";
                    break;
                default:      
            }
            $Complaint->complaint_desc = $request->complaint_desc;
            $Complaint->save();
            if($request->ajax()){
                return response()->json([
                        'message' => 'Complaint saved Successfully',
                        'success'=>1
                    ]);
            }
          
        }catch (Exception $e) {
            if($request->ajax()) {
                return response()->json(['message' => trans('api.something_went_wrong'), 'success'=>0],200);
            }
        }
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function services(Request $request) {

       try{
            $serviceList = ServiceType::all();
            return response()->json(['success'=>$serviceList], 200);
        }
        catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }        
    }

    public function fare_model(Request $request){

        if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }

        if($serviceList = FareModel::all()) {
            foreach ($serviceList as $key => $service_type) {
                $current = Carbon::now()->toTimeString();
                $currentday = Carbon::now()->format('l');
                $fare_base=0.00;
                $fare_distance=0.00;
                $fare_minute=0.00;
                $fare_waiting=0.00;

                if($currentday =='Saturday' || $currentday=='Sunday'){
                    if($current > $service_type->t1_s_stime && $current < $service_type->t1_s_etime){
                        $fare_base = $service_type->t1_s_base;
                        $fare_distance = $service_type->t1_s_distance;
                        $fare_minute = $service_type->t1_s_minute;
                        $fare_waiting = $service_type->t1_s_waiting;
                    }else if($current > $service_type->t2_s_stime && $current < $service_type->t2_s_etime){
                        $fare_base = $service_type->t2_s_base;
                        $fare_distance = $service_type->t2_s_distance;
                        $fare_minute = $service_type->t2_s_minute;
                        $fare_waiting = $service_type->t2_s_waiting;
                    }else if($current > $service_type->t3_s_stime && $current < $service_type->t3_s_etime){
                        $fare_base = $service_type->t3_s_base;
                        $fare_distance = $service_type->t3_s_distance;
                        $fare_minute = $service_type->t3_s_minute;
                        $fare_waiting = $service_type->t3_s_waiting;
                    }else if($current > $service_type->t4_s_stime && $current < $service_type->t4_s_etime){
                        $fare_base = $service_type->t4_s_base;
                        $fare_distance = $service_type->t4_s_distance;
                        $fare_minute = $service_type->t4_s_minute;
                        $fare_waiting = $service_type->t4_s_waiting;
                    }else{
                        $fare_base = $service_type->t1_s_base;
                        $fare_distance = $service_type->t1_s_distance;
                        $fare_minute = $service_type->t1_s_minute;
                        $fare_waiting = $service_type->t1_s_waiting;
                    }
                }else{
                    if($current > $service_type->t1_stime && $current < $service_type->t1_etime){
                        $fare_base = $service_type->t1_base;
                        $fare_distance = $service_type->t1_distance;
                        $fare_minute = $service_type->t1_minute;
                        $fare_waiting = $service_type->t1_waiting;
                    }else if($current > $service_type->t2_stime && $current < $service_type->t2_etime){
                        $fare_base = $service_type->t2_base;
                        $fare_distance = $service_type->t2_distance;
                        $fare_minute = $service_type->t2_minute;
                        $fare_waiting = $service_type->t2_waiting;
                    }else if($current > $service_type->t3_stime && $current < $service_type->t3_etime){
                        $fare_base = $service_type->t3_base;
                        $fare_distance = $service_type->t3_distance;
                        $fare_minute = $service_type->t3_minute;
                        $fare_waiting = $service_type->t3_waiting;
                    }else if($current > $service_type->t4_stime && $current < $service_type->t4_etime){
                        $fare_base = $service_type->t4_base;
                        $fare_distance = $service_type->t4_distance;
                        $fare_minute = $service_type->t4_minute;
                        $fare_waiting = $service_type->t4_waiting;
                    }else{
                        $fare_base = $service_type->t1_base;
                        $fare_distance = $service_type->t1_distance;
                        $fare_minute = $service_type->t1_minute;
                        $fare_waiting = $service_type->t1_waiting;
                    }
                }
                
                $service = ServiceType::where('id','=',$service_type->service_type_id)->first();
                $serviceList[$key]->fixed = $fare_base;
                $serviceList[$key]->distance = $fare_distance;
                $serviceList[$key]->minute = $fare_minute;
                $serviceList[$key]->waiting = $fare_waiting;
                $serviceList[$key]->name =$service->name;
                $serviceList[$key]->image =$service->image;
            }
            return response()->json(['success'=>$serviceList], 200);
        } else {
            return response()->json(['error' => trans('api.services_not_found')], 500);
        }
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function update_location(Request $request){

        $this->validate($request, [
                'latitude' => 'required|numeric',
                'longitude' => 'required|numeric',
            ]);

        if($user = User::find(Auth::user()->id)){


            $user->latitude = $request->latitude;
            $user->longitude = $request->longitude;
            $user->save();
            return response()->json(['success' => trans('api.user.location_updated')], 200);
        }else{
            return response()->json(['error' => trans('api.user.user_not_found')], 500);
        }

    }
    /**
     * get all promo code.
     *
     * @return \Illuminate\Http\Response
     */

    public function promocodes() {
        try{
            $this->check_expiry();

            return PromocodeUsage::Active()
                    ->where('user_id', Auth::user()->id)
                    ->with('promocode')
                    ->get();

        } catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    } 

    public function list_promocode(){

        try{
            $this->check_expiry();
            $new_user = Promocode::where('status','ADDED')
                ->where('user_type','new')
                ->where('updated_at','<=', Auth::user()->created_at)
                ->pluck('id')->toArray();
            $all_user = Promocode::where('status','ADDED')
                ->where('user_type','all')
                ->pluck('id')->toArray();

            $promo_id=array_merge($new_user,$all_user);
            $all = Promocode::whereIn('id',$promo_id)->get();
            foreach($all as $key => $code) {
                $all[$key]->currency =Setting::get('currency');
            }

            return response()->json(['promocode'=>$all, ]);    
        } catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }

    public function check_expiry(){
        try{ 
            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }
            $Promocode = Promocode::all();
            foreach ($Promocode as $index => $promo) {
                if(date("Y-m-d") > $promo->expiration){
                    $promo->status = 'EXPIRED';
                    $promo->save();
                    PromocodeUsage::where('promocode_id', $promo->id)->update(['status' => 'EXPIRED']);
                }
            }
        } catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }


    /**
     * add promo code.
     *
     * @return \Illuminate\Http\Response
     */

    public function add_promocode(Request $request) {

        $this->validate($request, [
                'promocode' => 'required|exists:promocodes,promo_code',
            ]);

        try{

            if(Auth::user()->admin_id !=  null){
            
             $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
           
             if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
                
             }
             }

            $find_promo = Promocode::where('promo_code',$request->promocode)->first();

            if($find_promo->status == 'EXPIRED' || (date("Y-m-d") > $find_promo->expiration)){

                if($request->ajax()){

                    return response()->json([
                        'message' => trans('api.promocode_expired'), 
                        'code' => 'promocode_expired'
                    ]);

                }else{
                    return back()->with('flash_error', trans('api.promocode_expired'));
                }

            }elseif(PromocodeUsage::where('promocode_id',$find_promo->id)->where('user_id', Auth::user()->id)->count() > 0){

                if($request->ajax()){

                    return response()->json([
                        'message' => trans('api.promocode_already_in_use'), 
                        'code' => 'promocode_already_in_use'
                        ]);

                }else{
                    return back()->with('flash_error', 'Promocode Already in use');
                }

            }else{

                $promo = new PromocodeUsage;
                $promo->promocode_id = $find_promo->id;
                $promo->user_id = Auth::user()->id;
                $promo->usage = $find_promo->use_count;
                $promo->status = 'ADDED';
                $promo->save();

                if($request->ajax()){

                    return response()->json([
                            'message' => trans('api.promocode_applied') ,
                            'code' => 'promocode_applied'
                         ]); 

                }else{
                    return back()->with('flash_success', trans('api.promocode_applied'));
                }
            }

        }

        catch (Exception $e) {
            if($request->ajax()){
                return response()->json(['error' => trans('api.something_went_wrong')], 500);
            }else{
                return back()->with('flash_error', 'Something Went Wrong');
            }
        }

    }

    public function fare_calc($service_type_id, $s_lat, $s_long, $d_lat, $d_long, $kilometer, $minutes){

        try {
            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }
        $check_type = 0;
        $fare_type = 0;
        $data_id = 0;
        $fare_flat = 0;
        $current = Carbon::now()->toTimeString();
        $currentday = Carbon::now()->format('l');

        $fare_base =0;
        $base_dist =0;
        $distance_fare =0;
        $min_fare=0;
        $fare_waiting=0;

        $location_bases = PoiFare::where('service_type_id','=',$service_type_id)->where('status','=',1)->select('id','poi_s_addr','poi_d_addr','service_type_id','reverse_loc')->get();
        if($check_type ==0){
            foreach($location_bases as $location_base){
                $location = Location::where('id','=',$location_base->poi_s_addr)->select('tlatitude','tlongitude','location_name')->first();
                if($location !=null){
                    $vertices_y = array_filter(explode(',', $location->tlatitude));
                    $vertices_x = array_filter(explode(',', $location->tlongitude));
                    $points_polygon = count($vertices_x);
                    $latitude_y = $s_lat;
                    $longitude_x = $s_long;
                }

                $location2 = Location::where('id','=',$location_base->poi_d_addr)->select('tlatitude','tlongitude','location_name')->first();
                if($location2 !=null){
                    $vertices_y2 = array_filter(explode(',', $location2->tlatitude));
                    $vertices_x2 = array_filter(explode(',', $location2->tlongitude));
                    $points_polygon2 = count($vertices_x2);
                    $latitude_y2 = $d_lat;
                    $longitude_x2 = $d_long;
                }

                if($location !=null && $location2 !=null && Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)==true && Helper::is_in_polygon($points_polygon2, $vertices_x2, $vertices_y2, $longitude_x2, $latitude_y2)==true){
                        $check_type = 1;
                        $fare_type = 1;
                        $data_id = $location_base->id;

                }else if($location_base->reverse_loc ==1 && $location !=null && $location2 !=null && Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x2, $latitude_y2)==true && Helper::is_in_polygon($points_polygon2, $vertices_x2, $vertices_y2, $longitude_x, $latitude_y)==true){
                        $check_type = 1;
                        $fare_type = 1;
                        $data_id = $location_base->id;

                }else{

                }
            }
            if($data_id !=0 && $check_type == 1){
                $fare_model = PoiFare::where('id','=',$data_id)->first();
                if($currentday =='Friday' || $currentday =='Saturday' || $currentday=='Sunday'){
                    if($current > $fare_model->t1_s_stime && $current < $fare_model->t1_s_etime){
                        $fare_flat = $fare_model->t1_s_flat;
                    }else if($current > $fare_model->t2_s_stime && $current < $fare_model->t2_s_etime){
                        $fare_flat = $fare_model->t2_s_flat;
                    }else if($current > $fare_model->t3_s_stime && $current < $fare_model->t3_s_etime){
                        $fare_flat = $fare_model->t3_s_flat;
                    }else if($current > $fare_model->t4_s_stime && $current < $fare_model->t4_s_etime){
                        $fare_flat = $fare_model->t4_s_flat;
                    }else{
                        $fare_flat = $fare_model->t1_s_flat;
                    }
                }else{
                    if($current > $fare_model->t1_stime && $current < $fare_model->t1_etime){
                        $fare_flat = $fare_model->t1_flat;
                    }else if($current > $fare_model->t2_stime && $current < $fare_model->t2_etime){
                        $fare_flat = $fare_model->t2_flat;
                    }else if($current > $fare_model->t3_stime && $current < $fare_model->t3_etime){
                        $fare_flat = $fare_model->t3_flat;
                    }else if($current > $fare_model->t4_stime && $current < $fare_model->t4_etime){
                        $fare_flat = $fare_model->t4_flat;
                    }else{
                        $fare_flat = $fare_model->t1_flat;
                    }
                }
            }
        }
        /////////////////////////////////
        //location wise fare starts
        /////////////////////////////
        $location_bases = LocationWiseFare::where('service_type_id','=',$service_type_id)->where('status','=',1)->select('id','source_addr','destination_addr','service_type_id','reverse_loc')->get();
        if($check_type ==0){
            foreach($location_bases as $location_base){
                $location = Location::where('id','=',$location_base->source_addr)->select('tlatitude','tlongitude','location_name')->first();
                if($location !=null){
                    $vertices_y = array_filter(explode(',', $location->tlatitude));
                    $vertices_x = array_filter(explode(',', $location->tlongitude));
                    $points_polygon = count($vertices_x);
                    $latitude_y = $s_lat;
                    $longitude_x = $s_long;
                }

                $location2 = Location::where('id','=',$location_base->destination_addr)->select('tlatitude','tlongitude','location_name')->first();
                if($location2 !=null){
                    $vertices_y2 = array_filter(explode(',', $location2->tlatitude));
                    $vertices_x2 = array_filter(explode(',', $location2->tlongitude));
                    $points_polygon2 = count($vertices_x2);
                    $latitude_y2 = $d_lat;
                    $longitude_x2 = $d_long;
                }

                if($location !=null && $location2 !=null && Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)==true && Helper::is_in_polygon($points_polygon2, $vertices_x2, $vertices_y2, $longitude_x2, $latitude_y2)==true){
                        $check_type = 1;
                        $fare_type = 2;
                        $data_id = $location_base->id;

                }else if($location_base->reverse_loc ==1 && $location !=null && $location2 !=null && Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x2, $latitude_y2)==true && Helper::is_in_polygon($points_polygon2, $vertices_x2, $vertices_y2, $longitude_x, $latitude_y)==true){
                        $check_type = 1;
                        $fare_type = 2;
                        $data_id = $location_base->id;

                }else{

                }
            }
            if($data_id !=0 && $check_type == 1){
                $fare_model = LocationWiseFare::where('id','=',$data_id)->first();
                if($currentday =='Friday' || $currentday =='Saturday' || $currentday=='Sunday'){
                    if($current > $fare_model->t1_s_stime && $current < $fare_model->t1_s_etime){
                        $fare_flat = $fare_model->t1_s_flat;
                    }else if($current > $fare_model->t2_s_stime && $current < $fare_model->t2_s_etime){
                        $fare_flat = $fare_model->t2_s_flat;
                    }else if($current > $fare_model->t3_s_stime && $current < $fare_model->t3_s_etime){
                        $fare_flat = $fare_model->t3_s_flat;
                    }else if($current > $fare_model->t4_s_stime && $current < $fare_model->t4_s_etime){
                        $fare_flat = $fare_model->t4_s_flat;
                    }else{
                        $fare_flat = $fare_model->t1_s_flat;
                    }
                }else{
                    if($current > $fare_model->t1_stime && $current < $fare_model->t1_etime){
                        $fare_flat = $fare_model->t1_flat;
                    }else if($current > $fare_model->t2_stime && $current < $fare_model->t2_etime){
                        $fare_flat = $fare_model->t2_flat;
                    }else if($current > $fare_model->t3_stime && $current < $fare_model->t3_etime){
                        $fare_flat = $fare_model->t3_flat;
                    }else if($current > $fare_model->t4_stime && $current < $fare_model->t4_etime){
                        $fare_flat = $fare_model->t4_flat;
                    }else{
                        $fare_flat = $fare_model->t1_flat;
                    }
                }
            }
        }

        if($check_type ==0){
            $fare_model = FareModel::where('service_type_id','=',$service_type_id)->first();
            if($fare_model !=null){
                if($currentday =='Friday' || $currentday =='Saturday' || $currentday=='Sunday'){
                    if($current > $fare_model->t1_s_stime && $current < $fare_model->t1_s_etime){
                        $fare_base = $fare_model->t1_s_base;
                        $base_dist = $fare_model->t1_s_base_dist;
                        $fare_distance = $fare_model->t1_s_distance;
                        $fare_minute = $fare_model->t1_s_minute;
                        $fare_waiting = $fare_model->t1_s_waiting;
                    }else if($current > $fare_model->t2_s_stime && $current < $fare_model->t2_s_etime){
                        $fare_base = $fare_model->t2_s_base;
                        $base_dist = $fare_model->t2_s_base_dist;
                        $fare_distance = $fare_model->t2_s_distance;
                        $fare_minute = $fare_model->t2_s_minute;
                        $fare_waiting = $fare_model->t2_s_waiting;
                    }else if($current > $fare_model->t3_s_stime && $current < $fare_model->t3_s_etime){
                        $fare_base = $fare_model->t3_s_base;
                        $base_dist = $fare_model->t3_s_base_dist;
                        $fare_distance = $fare_model->t3_s_distance;
                        $fare_minute = $fare_model->t3_s_minute;
                        $fare_waiting = $fare_model->t3_s_waiting;
                    }else if($current > $fare_model->t4_s_stime && $current < $fare_model->t4_s_etime){
                        $fare_base = $fare_model->t4_s_base;
                        $base_dist = $fare_model->t4_s_base_dist;
                        $fare_distance = $fare_model->t4_s_distance;
                        $fare_minute = $fare_model->t4_s_minute;
                        $fare_waiting = $fare_model->t4_s_waiting;
                    }else{
                        $fare_base = $fare_model->t1_s_base;
                        $base_dist = $fare_model->t1_s_base_dist;
                        $fare_distance = $fare_model->t1_s_distance;
                        $fare_minute = $fare_model->t1_s_minute;
                        $fare_waiting = $fare_model->t1_s_waiting;  
                    }
                }else{
                    if($current > $fare_model->t1_stime && $current < $fare_model->t1_etime){
                        $fare_base = $fare_model->t1_base;
                        $base_dist = $fare_model->t1_base_dist;
                        $fare_distance = $fare_model->t1_distance;
                        $fare_minute = $fare_model->t1_minute;
                        $fare_waiting = $fare_model->t1_waiting;
                    }else if($current > $fare_model->t2_stime && $current < $fare_model->t2_etime){
                        $fare_base = $fare_model->t2_base;
                        $base_dist = $fare_model->t2_base_dist;
                        $fare_distance = $fare_model->t2_distance;
                        $fare_minute = $fare_model->t2_minute;
                        $fare_waiting = $fare_model->t2_waiting;
                    }else if($current > $fare_model->t3_stime && $current < $fare_model->t3_etime){
                        $fare_base = $fare_model->t3_base;
                        $base_dist = $fare_model->t3_base_dist;
                        $fare_distance = $fare_model->t3_distance;
                        $fare_minute = $fare_model->t3_minute;
                        $fare_waiting = $fare_model->t3_waiting;
                    }else if($current > $fare_model->t4_stime && $current < $fare_model->t4_etime){
                        $fare_base = $fare_model->t4_base;
                        $base_dist = $fare_model->t4_base_dist;
                        $fare_distance = $fare_model->t4_distance;
                        $fare_minute = $fare_model->t4_minute;
                        $fare_waiting = $fare_model->t4_waiting;
                    }else{
                        $fare_base = $fare_model->t1_base;
                        $base_dist = $fare_model->t1_base_dist;
                        $fare_distance = $fare_model->t1_distance;
                        $fare_minute = $fare_model->t1_minute;
                        $fare_waiting = $fare_model->t1_waiting;   
                    }
                }
                $distance_fare=0.00;
                $min_fare=0.00;
                $base_distance = $base_dist;
                if($base_distance < $kilometer){
                    $kilometer1 = $kilometer - $base_distance;
                    $distance_fare = ($kilometer1 * $fare_distance);
                    $min_fare = ($fare_minute * $minutes);
                }
                $fare_flat = $fare_base + $distance_fare + $min_fare;
                $fare_type = 3;
            }    
        }
        //$vat_percent = ServiceType::where('id','=',$service_type_id)->pluck('vat_percent')->first();
        //$tax_price = $fare_flat * $vat_percent /100;
        $fare_final = $fare_flat;

        $result = array('fare_type' => $fare_type, 'fare_flat'=> $fare_final, 'data_id' =>$data_id, 'fare_base' =>$fare_base,'base_dist' =>$base_dist, 'distance_fare' =>$distance_fare, 'min_fare' =>$min_fare, 'fare_waiting' =>$fare_waiting);
        return $result;

        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function estimated_fare(Request $request){
        
        $this->validate($request,[
                's_latitude' => 'required|numeric',
                's_longitude' => 'required|numeric',
                'd_latitude' => 'required|numeric',
                'd_longitude' => 'required|numeric',
        ]);

        try{

            $details = "https://maps.googleapis.com/maps/api/directions/json?origin=".$request->s_latitude.",".$request->s_longitude."&destination=".$request->d_latitude.",".$request->d_longitude."&mode=driving&key=".Setting::get('map_key');
            $json = curl($details);
            $details = json_decode($json, TRUE);
            if($details['status'] !='OK'){
                return response()->json(['message' =>'Route not found', 'success' =>0]);
            }
            $meter = $details['routes'][0]['legs'][0]['distance']['value'];
            $time = $details['routes'][0]['legs'][0]['duration']['text'];
            $seconds = $details['routes'][0]['legs'][0]['duration']['value'];

            $unit =Setting::get('distance_unit');
            
            if($unit =='km'){
                $kilometer = $meter/1000;
            }else{
                $base = $meter/1000;
                $kilometer = $base * 0.62137119;
            }
            $kilometer = round($kilometer,2);
            $minutes = $seconds/60;
        $datas = array();    
        if($serviceList = ServiceType::all()) {
            foreach($serviceList as $key => $service_type) {
                $fare_calc = $this->fare_calc($service_type->id, $request->s_latitude, $request->s_longitude, $request->d_latitude, $request->d_longitude,$kilometer, $minutes);
                //dd($fare_calc);
                $data = array(
                        'estimated_fare' => round($fare_calc['fare_flat'],2), 
                        'distance' => $kilometer,
                        'distance_unit' => $unit,
                        'fare_type' => $fare_calc['fare_type'],
                        'fare_base' => $fare_calc['fare_base'],
                        'base_dist' => $fare_calc['base_dist'],
                        'distance_fare' => $fare_calc['distance_fare'],
                        'min_fare' => $fare_calc['min_fare'],
                        'fare_waiting' => $fare_calc['fare_waiting'],
                        'time' => $time,
                        'service_id' => $service_type->id,
                        'service_name' => $service_type->name,
                        'service_image' => $service_type->image,
                        'currency' => Setting::get('currency'),
                    );
                $datas[] = $data;
            }
        }    
        return response()->json(['data'=>$datas, 'success' =>1], 200);
            
        } catch(Exception $e) {
            return response()->json(['message' => trans('api.something_went_wrong'), 'success' =>0], 200);
        }
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function send_request(Request $request) {

        $this->validate($request, [
                's_latitude' => 'required|numeric',
                'd_latitude' => 'required|numeric',
                's_longitude' => 'required|numeric',
                'd_longitude' => 'required|numeric',
                'service_type' => 'required|numeric|exists:service_types,id',
                'promo_code' => 'exists:promocodes,promo_code',
                'payment_mode' => 'required|in:CASH,CARD,PAYPAL',
                'card_id' => ['required_if:payment_mode,CARD','exists:cards,card_id,user_id,'.Auth::user()->id],
            ]);

        if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }
        
        if(Auth::user()->due_balance !=0.00){
            if($request->ajax()) {
                return response()->json(['message' => 'Clear Pending Dues to take trip','success'=>0]);
            } else {
                return redirect('dashboard')->with('flash_error', 'Clear Pending Dues to take trip');
            }
        }

        $current = Carbon::now()->toTimeString();
        $restrict_pickup = RestrictLocation::whereIn('restrict_area',[1,2])->where('status','=',1)->get();
        foreach($restrict_pickup as $res_pickup){
            if($current > $res_pickup->s_time && $current < $res_pickup->e_time){
                $location = Location::where('id','=',$res_pickup->location_id)->select('tlatitude','tlongitude','location_name')->first();
                if($location !=null){
                    $vertices_y = array_filter(explode(',', $location->tlatitude));
                    $vertices_x = array_filter(explode(',', $location->tlongitude));
                    $points_polygon = count($vertices_x);
                    $latitude_y = $request->s_latitude;
                    $longitude_x = $request->s_longitude;
                    if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                        return response()->json(['message' => trans('Pickup Location Zone Restricted'),'success'=>0]);
                    }
                }
            }
        }
        $restrict_drop = RestrictLocation::whereIn('restrict_area',[1,3])->where('status','=',1)->get();
        foreach($restrict_drop as $res_drop){
            if($current > $res_drop->s_time && $current < $res_drop->e_time){
                $location = Location::where('id','=',$res_drop->location_id)->select('tlatitude','tlongitude','location_name')->first();
                if($location !=null){
                    $vertices_y = array_filter(explode(',', $location->tlatitude));
                    $vertices_x = array_filter(explode(',', $location->tlongitude));
                    $points_polygon = count($vertices_x);
                    $latitude_y = $request->d_latitude;
                    $longitude_x = $request->d_longitude;
                    if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                        return response()->json(['message' => trans('Destination Zone Restricted'), 'success'=>0]);
                    }
                }
            }
        }

        $corporate_id = 0;
        $corporate_group_id =0;
        if($request->corporate !=0){
            $corporate_user = CorporateUser::where('id','=',Auth::user()->corporate_user_id)->first();
            if($corporate_user !=null){
                $corporate = Corporate::where('id', $corporate_user->corporate_id)->first();
                if($corporate->status !=0){
                    $corporate_id = $corporate->id;
                    $corporate_group_id = $corporate_user->corporate_group_id;
                }else{
                    return response()->json(['message' => 'Corporate account is disabled', 'success' =>0]);
                }
            }else{
                return response()->json(['message' => 'Corporate account Not Found', 'success' =>0]);
            }
        }

        try{
            if(Auth::user()->trip_id !=0){
                return response()->json(['message' => trans('api.ride.request_inprogress'), 'success' =>0]);
            }

            if($request->has('schedule_date') && $request->has('schedule_time') && $request->schedule_date !=''){
                $beforeschedule_time = (new Carbon("$request->schedule_date $request->schedule_time"))->subMinute(15);
                $afterschedule_time = (new Carbon("$request->schedule_date $request->schedule_time"))->addMinute(15);

                $CheckScheduling = UserRequest::where('status','SCHEDULED')
                                ->where('user_id', Auth::user()->id)
                                ->whereBetween('schedule_at',[$beforeschedule_time,$afterschedule_time])
                                ->count();

                if($CheckScheduling > 0){
                    return response()->json(['message' => trans('api.ride.request_scheduled'), 'success' =>0]);
                }

            }

            if($request->has('schedule_date') && $request->has('schedule_time') && $request->schedule_date !=''){
                $details = "https://maps.googleapis.com/maps/api/directions/json?origin=".$request->s_latitude.",".$request->s_longitude."&destination=".$request->d_latitude.",".$request->d_longitude."&mode=driving&key=".Setting::get('map_key');
                $json = curl($details);
                $details = json_decode($json, TRUE);
                if($details['status'] !='OK'){
                    return response()->json(['message' =>'Route not found','success' =>0]);
                }
                $meter = $details['routes'][0]['legs'][0]['distance']['value'];
                $seconds = $details['routes'][0]['legs'][0]['duration']['value'];
                $route_key = $details['routes'][0]['overview_polyline']['points'];

                $unit =Setting::get('distance_unit');
            
                if($unit =='km'){
                    $kilometer = $meter/1000;
                }else{
                    $base = $meter/1000;
                    $kilometer = $base * 0.62137119;
                }
                
                $kilometer = round($kilometer,2);
                $minutes = $seconds/60;

                $fare_calc = $this->fare_calc($request->service_type, $request->s_latitude, $request->s_longitude, $request->d_latitude, $request->d_longitude,$kilometer, $minutes);
            
                $UserRequest = new UserRequest;
                $UserRequest->booking_id = 100;
                $UserRequest->admin_id = Auth::user()->admin_id;
                $UserRequest->user_id = Auth::user()->id;
                $UserRequest->user_name = Auth::user()->first_name;
                $UserRequest->user_mobile = Auth::user()->dial_code.Auth::user()->mobile;
                $UserRequest->service_type_id = $request->service_type;
                $UserRequest->corporate_id = $corporate_id;
                $UserRequest->group_id = $corporate_group_id;
                $UserRequest->payment_mode = $request->payment_mode;
                $UserRequest->status = 'SCHEDULED';
                $UserRequest->trip_status = 'scheduled';
                $UserRequest->push = 'AUTO';
                $UserRequest->booking_by = 'APP';

                $UserRequest->s_address = $request->s_address ? : "";
                $UserRequest->s_latitude = $request->s_latitude;
                $UserRequest->s_longitude = $request->s_longitude;
                $UserRequest->d_address = $request->d_address ? : "";
                $UserRequest->d_latitude = $request->d_latitude;
                $UserRequest->d_longitude = $request->d_longitude;
                $UserRequest->stop1_latitude = $request->stop1_latitude ? : "";
                $UserRequest->stop1_longitude = $request->stop1_longitude;
                $UserRequest->stop1_address = $request->stop1_address;
                $UserRequest->stop2_latitude = $request->stop2_latitude ? : "";
                $UserRequest->stop2_longitude = $request->stop2_longitude;
                $UserRequest->stop2_address = $request->stop2_address;

                $UserRequest->route_key = $route_key;
                $UserRequest->message = $request->message ? : "";
                $UserRequest->handicap = $request->handicap_access ? : 0;
                $UserRequest->pet = $request->travel_pet ? : 0;
                $UserRequest->wagon = $request->station_wagon ? : 0;
                $UserRequest->booster = $request->booster_seat ? : 0;
                $UserRequest->fixed_rate = $request->fixed_rate ? : 0;
                // $UserRequest->child_seat_booster = $request->child_seat_booster ? : 0;
                // $UserRequest->child_seat_forward = $request->child_seat_forward ? : 0;
                // $UserRequest->child_seat_rear = $request->child_seat_rear ? : 0;
                // $UserRequest->ladies_only = $request->ladies_only ? : 0;
                $UserRequest->distance = $kilometer;
                $UserRequest->minutes = $minutes;
                $UserRequest->fare_type = $fare_calc['fare_type'];
                $UserRequest->estimated_fare = round($fare_calc['fare_flat'],2);
                $UserRequest->assigned_at = Carbon::now();

                $UserRequest->surge = 0;
                $UserRequest->schedule_at = date("Y-m-d H:i:s",strtotime("$request->schedule_date $request->schedule_time"));
                 // $UserRequest->schedule_at = date("m-d-Y H:i:s",strtotime("$request->schedule_date $request->schedule_time"));

                $UserRequest->save();
                $UserRequest->booking_id = '100'.$UserRequest->id;
                $UserRequest->save();
                if($UserRequest->schedule_at < Carbon::now()->addHour(Setting::get('feature_time'))){
                    // $this->notify_driver($UserRequest->id);
                }
                

                return response()->json([
                        'message' => trans('api.new_request_dispatcher'),
                        'request_id' => $UserRequest->id,
                        'scheduled_status' => 1,
                        'success' =>1
                    ]);
            }

            if(Auth::user()->trip_id !=0){
                return response()->json(['message' => trans('api.ride.request_inprogress'), 'success' =>0]);
            }

           // $details = "https://maps.googleapis.com/maps/api/directions/json?origin=".$request->s_latitude.",".$request->s_longitude."&destination=".$request->d_latitude.",".$request->d_longitude."&mode=driving&key=".env('GOOGLE_MAP_KEY');
            $details = "https://maps.googleapis.com/maps/api/directions/json?origin=".$request->s_latitude.",".$request->s_longitude."&destination=".$request->d_latitude.",".$request->d_longitude."&mode=driving&key=".Setting::get('map_key');
        $json = curl($details);
            $details = json_decode($json, TRUE);
            if($details['status'] !='OK'){
                return response()->json(['message' =>'Route not found', 'success' =>0]);
            }
            $meter = $details['routes'][0]['legs'][0]['distance']['value'];
            $seconds = $details['routes'][0]['legs'][0]['duration']['value'];
            $route_key = $details['routes'][0]['overview_polyline']['points'];

            $unit =Setting::get('distance_unit');
            
            if($unit =='km'){
                $kilometer = $meter/1000;
            }else{
                $base = $meter/1000;
                $kilometer = $base * 0.62137119;
            }
            
            $kilometer = round($kilometer,2);
            $minutes = $seconds/60;
            $fare_calc = $this->fare_calc($request->service_type, $request->s_latitude, $request->s_longitude, $request->d_latitude, $request->d_longitude,$kilometer, $minutes);
            
            $UserRequest = new UserRequest;
            $UserRequest->booking_id = 100;
            $UserRequest->admin_id = Auth::user()->admin_id;
            $UserRequest->user_id = Auth::user()->id;
            $UserRequest->user_name = Auth::user()->first_name;
            $UserRequest->user_mobile = Auth::user()->dial_code.Auth::user()->mobile;
            $UserRequest->service_type_id = $request->service_type;
            $UserRequest->corporate_id = $corporate_id;
            $UserRequest->group_id = $corporate_group_id;
            $UserRequest->payment_mode = $request->payment_mode;
            $UserRequest->status = 'SEARCHING';
            $UserRequest->push = 'AUTO';
            $UserRequest->booking_by = 'APP';
            $UserRequest->s_address = $request->s_address ? : "";
            $UserRequest->d_address = $request->d_address ? : "";
            $UserRequest->s_latitude = $request->s_latitude;
            $UserRequest->s_longitude = $request->s_longitude;
            $UserRequest->d_latitude = $request->d_latitude;
            $UserRequest->d_longitude = $request->d_longitude;
            $UserRequest->stop1_latitude = $request->stop1_latitude ? : "";
            $UserRequest->stop1_longitude = $request->stop1_longitude;
            $UserRequest->stop1_address = $request->stop1_address;
            $UserRequest->stop2_latitude = $request->stop2_latitude ? : "";
            $UserRequest->stop2_longitude = $request->stop2_longitude;
            $UserRequest->stop2_address = $request->stop2_address;
            $UserRequest->distance = $kilometer;
            $UserRequest->minutes = $minutes;
            $UserRequest->fare_type = $fare_calc['fare_type'];
            $UserRequest->estimated_fare = round($fare_calc['fare_flat'],2);
            $UserRequest->message = $request->message ? : "";
            $UserRequest->handicap = $request->handicap_access ? : 0;
            $UserRequest->pet = $request->travel_pet ? : 0;
            $UserRequest->wagon = $request->station_wagon ? : 0;
            $UserRequest->booster = $request->booster_seat ? : 0;
            $UserRequest->fixed_rate = $request->fixed_rate ? : 0;
            // $UserRequest->child_seat_booster = $request->child_seat_booster ? : 0;
            // $UserRequest->child_seat_forward = $request->child_seat_forward ? : 0;
            // $UserRequest->child_seat_rear = $request->child_seat_rear ? : 0;
            // $UserRequest->ladies_only = $request->ladies_only ? : 0;
            $UserRequest->assigned_at = Carbon::now();
            $UserRequest->route_key = $route_key;
            $UserRequest->save();
            $UserRequest->booking_id = '100'.$UserRequest->id;
            $UserRequest->save();
            if($request->has('card_id')){
                Card::where('user_id',Auth::user()->id)->update(['is_default' => 0]);
                Card::where('card_id',$request->card_id)->update(['is_default' => 1]);
            }
            User::where('id',Auth::user()->id)->update(['trip_id' => $UserRequest->id]);
            $this->notify_driver($UserRequest->id);
            return response()->json([
                    'message' => trans('api.new_request_created'),
                    'request_id' => $UserRequest->id,
                    'scheduled_status' => 0,
                    'success' =>1
                ]);
            
        }catch (Exception $e) {
            return response()->json(['message' => $e->getMessage(), 'success' =>0], 200);
        }
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function repeat_request(Request $request) {

        $this->validate($request, [
                'request_id' => 'required|numeric',
                'trip_type' => 'required|numeric',
            ]);

        if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }
        if(Auth::user()->due_balance !=0.00){
            return response()->json(['message' => 'Clear Pending Dues to take trip','success'=>0 ]); 
        }
        if(Auth::user()->trip_id != 0){
            return response()->json(['message' => trans('api.ride.request_inprogress'), 'success'=>0]);
        }

        $Repeat = UserRequest::findOrFail($request->request_id);

        if($request->trip_type ==1){
            $s_address = $Repeat->d_address;
            $s_latitude = $Repeat->d_latitude;
            $s_longitude = $Repeat->d_longitude;
            $d_address = $Repeat->s_address;
            $d_latitude = $Repeat->s_latitude;
            $d_longitude = $Repeat->s_longitude;
            $stop1_address = $Repeat->stop1_address;
            $stop1_latitude = $Repeat->stop1_latitude;
            $stop1_longitude = $Repeat->stop1_longitude;
            $stop2_address = $Repeat->stop2_address;
            $stop2_latitude = $Repeat->stop2_latitude;
            $stop2_longitude = $Repeat->stop2_longitude;
        }else{
            $s_address = $Repeat->s_address;
            $s_latitude = $Repeat->s_latitude;
            $s_longitude = $Repeat->s_longitude;
            $d_address = $Repeat->d_address;
            $d_latitude = $Repeat->d_latitude;
            $d_longitude = $Repeat->d_longitude;
            $stop1_address = $Repeat->stop1_address;
            $stop1_latitude = $Repeat->stop1_latitude;
            $stop1_longitude = $Repeat->stop1_longitude;
            $stop2_address = $Repeat->stop2_address;
            $stop2_latitude = $Repeat->stop2_latitude;
            $stop2_longitude = $Repeat->stop2_longitude;
        }
        $current = Carbon::now()->toTimeString();
        $restrict_pickup = RestrictLocation::whereIn('restrict_area',[1,2])->where('status','=',1)->get();
        foreach($restrict_pickup as $res_pickup){
            if($current > $res_pickup->s_time && $current < $res_pickup->e_time){
                $location = Location::where('id','=',$res_pickup->location_id)->select('tlatitude','tlongitude','location_name')->first();
                if($location !=null){
                    $vertices_y = array_filter(explode(',', $location->tlatitude));
                    $vertices_x = array_filter(explode(',', $location->tlongitude));
                    $points_polygon = count($vertices_x);
                    $latitude_y = $s_latitude;
                    $longitude_x = $s_longitude;
                    if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                        return response()->json(['message' => trans('Pickup Location Zone Restricted'), 'success'=>0]);
                    }
                }
            }
        }
        $restrict_drop = RestrictLocation::whereIn('restrict_area',[1,3])->where('status','=',1)->get();
        foreach($restrict_drop as $res_drop){
            if($current > $res_drop->s_time && $current < $res_drop->e_time){
                $location = Location::where('id','=',$res_drop->location_id)->select('tlatitude','tlongitude','location_name')->first();
                if($location !=null){
                    $vertices_y = array_filter(explode(',', $location->tlatitude));
                    $vertices_x = array_filter(explode(',', $location->tlongitude));
                    $points_polygon = count($vertices_x);
                    $latitude_y = $d_latitude;
                    $longitude_x = $d_longitude;
                    if(Helper::is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)){
                        return response()->json(['message' => trans('Destination Zone Restricted'), 'success'=>0]);
                    }
                }
            }
        }

        $corporate_id = 0;
        $corporate_group_id =0;
        if($Repeat->corporate_id !=0){
            $corporate_user = CorporateUser::where('id','=',Auth::user()->corporate_user_id)->first();
            if($corporate_user !=null){
                $corporate = Corporate::where('id', $corporate_user->corporate_id)->first();
                if($corporate->status !=0){
                    $corporate_id = $corporate->id;
                    $corporate_group_id = $corporate_user->corporate_group_id;
                }else{
                    return response()->json(['message' => 'Corporate account is disabled', 'success' =>0]);
                }
            }else{
                return response()->json(['message' => 'Corporate account Not Found', 'success' =>0]);
            }
        }

        try{
            
            $ActiveRequests = UserRequest::where('user_id', Auth::user()->id)
                        ->whereNotIn('status' , ['CANCELLED', 'COMPLETED', 'SCHEDULED'])
                        ->count();
                        
            if($ActiveRequests > 0) {
                return response()->json(['message' => trans('api.ride.request_inprogress'), 'success'=>0]);
            }

            $unit =Setting::get('distance_unit');
            
            $fare_calc = $this->fare_calc($Repeat->service_type_id, $s_latitude, $s_longitude, $d_latitude, $d_longitude,$Repeat->kilometer, $Repeat->minutes);
            
            $UserRequest = new UserRequest;
            $UserRequest->booking_id = 100;
            $UserRequest->admin_id = $Repeat->admin_id;
            $UserRequest->user_id = $Repeat->user_id;
            $UserRequest->user_name = $Repeat->user_name;
            $UserRequest->user_mobile = $Repeat->user_mobile;
            $UserRequest->service_type_id = $Repeat->service_type_id;
            $UserRequest->corporate_id = $corporate_id;
            $UserRequest->group_id = $corporate_group_id;
            $UserRequest->payment_mode = $Repeat->payment_mode;
            $UserRequest->status = 'SEARCHING';
            $UserRequest->push = 'AUTO';
            $UserRequest->booking_by = 'APP';
            $UserRequest->s_address = $s_address;
            $UserRequest->d_address = $d_address;
            $UserRequest->s_latitude = $s_latitude;
            $UserRequest->s_longitude = $s_longitude;
            $UserRequest->d_latitude = $d_latitude;
            $UserRequest->d_longitude = $d_longitude;
            $UserRequest->distance = $Repeat->distance;
            $UserRequest->minutes = $Repeat->minutes;
            $UserRequest->fare_type =$Repeat->fare_type;
            $UserRequest->estimated_fare = round($fare_calc['fare_flat'],2);
            $UserRequest->message = $Repeat->message;
            $UserRequest->handicap = $Repeat->handicap;
            $UserRequest->pet = $Repeat->pet;
            $UserRequest->wagon = $Repeat->wagon;
            $UserRequest->booster = $Repeat->booster;
            $UserRequest->fixed_rate = $Repeat->fixed_rate;
            $UserRequest->assigned_at = Carbon::now();
            $UserRequest->route_key = $Repeat->route_key;
            $UserRequest->save();
            $UserRequest->booking_id = '100'.$UserRequest->id;
            $UserRequest->save();

            $this->notify_driver($UserRequest->id);
            User::where('id',Auth::user()->id)->update(['trip_id' => $UserRequest->id]);
            return response()->json([
                    'message' => trans('api.new_request_created'),
                    'request_id' => $UserRequest->id,
                    'scheduled_status' => 0,
                    'success'=>1
                ]);
            
        }catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function notify_driver($id) {

        try {

            if(Auth::user()->admin_id !=  null){
            
             $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
           
             if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
                
             }
            }
            $UserRequest = UserRequest::where('id','=', $id)
                    ->select('id','created_at','booking_id','service_type_id','s_address','d_address','distance','schedule_at','assigned_at','status','s_latitude','s_longitude')
                    ->orderBy('created_at','desc')
                    ->first();

            $start = Carbon::parse($UserRequest->assigned_at);
            $now = Carbon::now();
            $seconds = $now->diffInSeconds($start);
            $latitude = $UserRequest->s_latitude;
            $longitude=$UserRequest->s_longitude;
            $distance=Setting::get('distance_5', '20');
            $data =[];
            $Providers = Provider::where('account_status', 'approved')
                        ->where('admin_id','=',Auth::user()->admin_id)
                        ->where('status','=','active')
                        ->where('service_type_id','=', $UserRequest->service_type_id);

            if($UserRequest->admin_id !=null){
                $Providers->where('providers.admin_id', '=', $UserRequest->admin_id);
            }             

            $Providers = $Providers->selectRaw("id , (1.609344 * 3956 * acos( cos( radians('$latitude') ) * cos( radians(latitude) ) * cos( radians(longitude) - radians('$longitude') ) + sin( radians('$latitude') ) * sin( radians(latitude) ) ) ) AS distance, latitude, longitude")
                        ->having('distance', '<', $distance)
                        //->orderBy('active_from', 'asc')
                        ->orderBy('distance')
                        ->get();

            (new SendPushNotification)->IncomingTrip($Providers[0]->id);
            $UserRequest->current_provider_id =  $Providers[0]->id;
            $UserRequest->save();
            Provider::where('id',$Providers[0]->id)->update(['trip_id' => $UserRequest->id]);

            foreach ($Providers as $key => $Provider) {
                $Filter = new RequestFilter;
                $Filter->request_id = $UserRequest->id;
                $Filter->provider_id = $Provider->id; 
                $Filter->save();
            }


            /*$shortfilter = $Providers->having('distance', '<=', $distance)
                      ->get()->pluck('id')->toArray();
            if(count($shortfilter) >0){
                //(new SendPushNotification)->IncomingTrip($shortfilter); 
                $data[]= $shortfilter;
            }
            
            $filter = $Providers->get();
            foreach($filter as $provider){
                $distance = Helper::distance($UserRequest->s_latitude, $UserRequest->s_longitude, $provider->latitude, $provider->longitude, "K");
                $distance_short = $distance*1000;
                if($distance_short <= Setting::get('distance_1', '500')){
                    (new SendPushNotification)->IncomingTrip($provider->id); 
                }else if($distance <=Setting::get('distance_2', '1')){
                    (new SendPushNotification)->IncomingTrip($provider->id);
                }else if($distance <=Setting::get('distance_3', '2')){
                   (new SendPushNotification)->IncomingTrip($provider->id);     
                }else if($distance <=Setting::get('distance_4', '3')){
                    (new SendPushNotification)->IncomingTrip($provider->id);
                }else if($distance <=Setting::get('distance_5', '4')){
                    (new SendPushNotification)->IncomingTrip($provider->id);
                }else{
                    (new SendPushNotification)->IncomingTrip($provider->id);
                }   
            }*/
        } catch (Exception $e) {
            
        }
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function cancel_request(Request $request) {

        $this->validate($request, [
            'request_id' => 'required|numeric|exists:user_requests,id,user_id,'.Auth::user()->id,
        ]);

        try{
            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }
            $UserRequest = UserRequest::findOrFail($request->request_id);
            if($UserRequest->status == 'CANCELLED')
            {
                return response()->json(['error' => trans('api.ride.already_cancelled')], 500);   
            }

            if(in_array($UserRequest->status, ['SEARCHING','STARTED','ARRIVED','SCHEDULED','ACCEPTED'])) {

                RequestFilter::where('request_id', $UserRequest->id)->delete();

                if($UserRequest->status != 'SEARCHING'){
                    $this->validate($request, [
                        'cancel_reason'=> 'max:255',
                    ]);
                }

                if($UserRequest->status != 'SCHEDULED'){
                    if($UserRequest->provider_id != 0){
                        Provider::where('id',$UserRequest->provider_id)->update(['trip_id' => 0,'status' => 'active', 'active_from' =>Carbon::now()]);
                    }
                }

                User::where('id',Auth::user()->id)->update(['trip_id' => 0]);
                $UserRequest->status = 'CANCELLED';
                $UserRequest->cancel_reason = $request->cancel_reason;
                $UserRequest->cancelled_by = 'USER';
                $UserRequest->save();

                 // Send Push Notification to User
                (new SendPushNotification)->UserCancellRide($UserRequest);
                return response()->json(['message' => trans('api.ride.ride_cancelled')]); 
                
            } else {
                return response()->json(['error' => trans('api.ride.already_onride')], 500); 
            }
        }
        catch (ModelNotFoundException $e) {
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }

    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function status(Request $request){

        try {
            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }
            if($user = User::find(Auth::user()->id)){
                if($request->has('latitude')){
                    $user->latitude = $request->latitude;
                    $user->longitude = $request->longitude;
                    $user->save();
                }
        
                if($user->trip_id !=0){
                    $UserRequest = UserRequest::where('id','=',$user->trip_id)->select('id','status','provider_id')->first();
                    $status =$UserRequest->status;
                    $trip_id =$UserRequest->id;
                    if($UserRequest->provider_id !=0){
                        $provider = Provider::where('id',$UserRequest->provider_id)->select('latitude','longitude')->first();
                        $latitude = $provider->latitude;
                        $longitude = $provider->longitude;
                    }else{
                        $latitude = '';
                        $longitude = '';
                    }
                }else{
                    $status ='';
                    $trip_id ='';
                    $latitude = '';
                    $longitude = '';
                }
                return response()->json(['data' => $status, 'trip_id' => $trip_id,'latitude' => $latitude,'longitude' => $longitude]);
            }else{
                return response()->json(['error' => trans('api.user.user_not_found')], 200);
            }
        }catch (Exception $e){
            return response()->json(['error' => 'Something Went Wrong'], 200);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function start_detail(Request $request)
    {
        try {
            $UserRequests = UserRequest::where('user_requests.status', '=', 'STARTED')
            ->where('user_id', '=', Auth::user()->id)
            ->join('providers', 'user_requests.provider_id', '=', 'providers.id')
            ->join('vehicles', 'providers.mapping_id', '=', 'vehicles.id')
            ->join('service_types', 'vehicles.service_type_id', '=', 'service_types.id')
            ->select('providers.name as driver_name','providers.mobile','providers.avatar','providers.rating','vehicles.vehicle_no','service_types.name as service_name','service_types.image as service_image','user_requests.status','user_requests.corporate_id','user_requests.s_address','user_requests.s_latitude','user_requests.s_longitude','user_requests.d_address','user_requests.d_latitude','user_requests.d_longitude')
            ->first();
            if($UserRequests !=null){
                $UserRequests->avatar = asset('storage/'.$UserRequests->avatar); 
            }
            return $UserRequests;

        }catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function arrived_detail(Request $request)
    {
        try {

            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }

            $UserRequests = UserRequest::where('user_requests.status', '=', 'ARRIVED')
            ->where('user_id', '=', Auth::user()->id)
            ->join('providers', 'user_requests.provider_id', '=', 'providers.id')
            ->join('vehicles', 'providers.mapping_id', '=', 'vehicles.id')
            ->join('service_types', 'vehicles.service_type_id', '=', 'service_types.id')
            ->select('providers.name as driver_name','providers.mobile','providers.avatar','providers.rating','vehicles.vehicle_no','service_types.name as service_name','service_types.image as service_image','user_requests.s_address','user_requests.s_latitude','user_requests.s_longitude','user_requests.d_address','user_requests.d_latitude','user_requests.d_longitude', 'user_requests.corporate_id')
            ->first();
            if($UserRequests !=null){
                $UserRequests->avatar = asset('storage/'.$UserRequests->avatar); 
            }
            return $UserRequests;

        }catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function pickedup_detail(Request $request)
    {
        try {
            if(Auth::user()->admin_id !=  null){
            $admin = Admin::where('id','=',Auth::user()->admin_id)->first();
            if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
             }
         }
         
            $UserRequests = UserRequest::where('user_requests.status', '=', 'PICKEDUP')
            ->where('user_id', '=', Auth::user()->id)
            ->join('providers', 'user_requests.provider_id', '=', 'providers.id')
            ->join('vehicles', 'providers.mapping_id', '=', 'vehicles.id')
            ->join('service_types', 'vehicles.service_type_id', '=', 'service_types.id')
            ->select('providers.name as driver_name','providers.mobile','providers.avatar','providers.rating','vehicles.vehicle_no','service_types.name as service_name','service_types.image as service_image','user_requests.s_address','user_requests.s_latitude','user_requests.s_longitude','user_requests.d_address','user_requests.d_latitude','user_requests.d_longitude', 'user_requests.corporate_id')
            ->first();

            if($UserRequests !=null){
                $UserRequests->avatar = asset('storage/'.$UserRequests->avatar); 
            }
            return $UserRequests;

        }catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function dropped_detail(Request $request)
    {
        try {
            $UserRequests = UserRequest::where('user_requests.status', '=', 'DROPPED')
            ->where('user_id', '=', Auth::user()->id)
            ->join('providers', 'user_requests.provider_id', '=', 'providers.id')
            ->join('vehicles', 'providers.mapping_id', '=', 'vehicles.id')
            ->join('service_types', 'vehicles.service_type_id', '=', 'service_types.id')
            ->join('user_request_payments', 'user_requests.id', '=', 'user_request_payments.request_id')
            ->select('providers.name as driver_name','providers.mobile','providers.avatar','providers.rating','vehicles.vehicle_no','service_types.name as service_name','service_types.image as service_image','user_requests.booking_id','user_requests.distance','user_requests.s_address','user_requests.s_latitude','user_requests.s_longitude','user_requests.d_address','user_requests.d_latitude','user_requests.d_longitude','user_requests.payment_update','user_requests.corporate_id','user_request_payments.total','user_request_payments.discount','user_request_payments.currency','user_request_payments.payment_id','user_request_payments.payment_mode','user_request_payments.base_fare','user_request_payments.distance_fare','user_request_payments.min_fare','user_request_payments.waiting_fare','user_request_payments.vat','user_request_payments.discount','user_request_payments.toll','user_request_payments.extra_fare','user_request_payments.extra_desc','user_request_payments.cash','user_request_payments.total')
            ->first();

            return $UserRequests;

        }catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */


    public function rate_provider(Request $request) {

        $this->validate($request, [
                'request_id' => 'required|integer|exists:user_requests,id,user_id,'.Auth::user()->id,
                'rating' => 'required',
                'comment' => 'max:255',
            ]);
    
        $UserRequests = UserRequest::where('id' ,$request->request_id)
                ->where('status' ,'COMPLETED')
                ->where('paid', 0)
                ->first();

        if ($UserRequests) {
            return response()->json(['error' => trans('api.user.not_paid')], 500);
        }

        try{

            $UserRequest = UserRequest::findOrFail($request->request_id);
            if($UserRequest->rating == null) {
                UserRequestRating::create([
                        'provider_id' => $UserRequest->provider_id,
                        'user_id' => $UserRequest->user_id,
                        'request_id' => $UserRequest->id,
                        'user_rating' => $request->rating,
                        'user_comment' => $request->comment,
                    ]);
            } else {
                $UserRequest->rating->update([
                        'user_rating' => $request->rating,
                        'user_comment' => $request->comment,
                    ]);
            }

            $UserRequest->user_rated = 1;
            $UserRequest->save();

            $average = UserRequestRating::where('provider_id', $UserRequest->provider_id)->avg('user_rating');

            Provider::where('id',$UserRequest->provider_id)->update(['rating' => $average]);
            User::where('id', $UserRequest->user_id)->update(['trip_id' => 0]);
            // Send Push Notification to Provider 
            return response()->json(['message' => trans('api.ride.provider_rated')]); 
            
        } catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }

    }
    /**
     * Show the completed trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function past_trips() {
    
        try{
            $UserRequests = UserRequest::where('user_id', '=', Auth::user()->id)
                    ->whereIn('user_requests.status', ['COMPLETED', 'CANCELLED'])
                    ->join('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
                    ->select('user_requests.id','user_requests.booking_id','service_types.name','user_requests.status','user_requests.s_address','user_requests.d_address','user_requests.stop1_address','user_requests.stop2_address','user_requests.distance','user_requests.minutes','user_requests.corporate_id','finished_at','user_requests.created_at')
                    ->orderBy('created_at','desc')
                    ->get();
        
            return $UserRequests;
        }
        catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    public function all_trips() {
    
        try{
            $UserRequests = UserRequest::where('user_id', '=', Auth::user()->id)
                    // ->whereIn('user_requests.status', ['COMPLETED', 'CANCELLED'])
                    ->join('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
                    ->select('user_requests.id','user_requests.booking_id','service_types.name','user_requests.status','user_requests.s_address','user_requests.d_address','user_requests.stop1_address','user_requests.stop2_address','user_requests.distance','user_requests.minutes','user_requests.corporate_id','finished_at','user_requests.created_at')
                    ->orderBy('created_at','desc')
                    ->get();
        
            return $UserRequests;
        }
        catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    /**
     * Show the Offered Trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function past_details(Request $request, $id) {
    
        try{
            $UserRequests = UserRequest::where('user_requests.id','=', $id)
                    ->where('user_id', '=', Auth::user()->id)
                    ->join('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
                    ->select('user_requests.id','booking_id','provider_id','s_latitude','s_longitude','stop1_latitude','stop1_longitude','stop2_latitude','stop2_longitude','d_latitude','d_longitude','service_types.name','user_requests.status','payment_mode','s_address','d_address','stop1_address','stop2_address','distance','minutes','provider_rated','corporate_id','finished_at','user_requests.created_at')
                    ->first();
            
                if(!empty($UserRequests)){
                    $UserRequests->distance = $UserRequests->distance.Setting::get('distance_unit');
                    if($UserRequests->status =='COMPLETED'){
                        $provider = Provider::where('id',$UserRequests->provider_id)->select('name','avatar')->first();
                        $UserRequests->driver_name = $provider->name;
                        $UserRequests->avatar = asset('storage/'.$provider->avatar);
                        $UserRequests->payment = UserRequestPayment::where('request_id',$UserRequests->id)->first();
                        $UserRequests->comment = UserRequestRating::where('request_id',$UserRequests->id)->pluck('provider_comment')->first();          
                    }    
                }
           
            return $UserRequests;
        }
        catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    /**
     * Show the completed trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function scheduled_trips() {
    
        try{
            $UserRequests = UserRequest::where('user_id', '=', Auth::user()->id)
                    ->where('user_requests.status', '!=', 'CANCELLED')
                    ->Where('user_requests.status', '!=', 'COMPLETED')
                    ->join('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
                    ->select('user_requests.id','booking_id','service_types.name','user_requests.status','s_address','d_address','stop1_address','stop2_address','distance','minutes','schedule_at','user_requests.corporate_id','user_requests.created_at')
                    ->orderBy('created_at','desc')
                    ->get();
            if(!empty($UserRequests)){
                foreach ($UserRequests as $key => $value) {
                    if($value->status =='DROPPED'){
                        $UserRequests[$key]->total = Setting::get('currency').UserRequestPayment::where('request_id',$value->id)->pluck('total')->first();
                    }    
                    $UserRequests[$key]->distance = $value->distance.Setting::get('distance_unit');       
                }
            }
            return $UserRequests;
        }
        catch (Exception $e){
            return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    /**
     * Show the Offered Trips.
     *
     * @return \Illuminate\Http\Response
     */

    public function scheduled_details(Request $request, $id) {
    
        try{
            $UserRequests = UserRequest::where('user_requests.id','=', $id)
                    ->where('user_id', '=', Auth::user()->id)
                    ->join('service_types', 'user_requests.service_type_id', '=', 'service_types.id')
                    ->select('user_requests.id','provider_id','booking_id','s_latitude','s_longitude','stop1_latitude','stop1_longitude','stop2_latitude','stop2_longitude','d_latitude','d_longitude','route_key','service_type_id','service_types.name','user_requests.status','payment_mode','s_address','d_address','stop1_address','stop2_address','distance','minutes','user_requests.created_at','schedule_at','accepted_at','user_requests.corporate_id','started_at','finished_at')
                    ->first();
                if(!empty($UserRequests)){
                    if($UserRequests->status !='SCHEDULED' && $UserRequests->status !='SEARCHING'){
                        $provider = Provider::where('id',$UserRequests->provider_id)->select('name','mobile','avatar','rating')->first();
                        $UserRequests->driver_name = $provider->name;
                        $UserRequests->driver_mobile = $provider->mobile;
                        $UserRequests->avatar = asset('storage/'.$provider->avatar);
                        $UserRequests->driver_rating = $provider->rating;         
                    }
                    $UserRequests->distance = $UserRequests->distance.Setting::get('distance_unit');
            
                    if($UserRequests->status =='DROPPED'){
                        $UserRequests->total = Setting::get('currency').UserRequestPayment::where('request_id',$UserRequests->id)->pluck('total')->first();
                    }         
                }else{
                    return response()->json(['data' => $UserRequests]);
                }
           
            return $UserRequests;
        }
        catch (Exception $e){
           return response()->json(['error' => trans('api.something_went_wrong')]);
        }
    }

    public function clear_status(Request $request) {
        User::where('id', Auth::user()->id)->update(['trip_id' => 0]);
        return response()->json(['message'=>'status cleared!']);
    }

    public function pushnotification(Request $request)
    {
        try {
            $passenger = "passenger";
            $pushMsg = MemberNotification::where('person_id', Auth::user()->id)->where('member',$passenger)->get();
            return response()->json(['success' => "1", "message"=>$pushMsg], 200); 
            // return response()->json(['pushMessage' => $pushMsg]);
        } catch (Exception $e) {
            return response()->json(['error' => trans('api.something_went_wrong')], 500);
        }
    }
}
