<?php

namespace App\Http\Controllers\Resource;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Setting;
use Exception;
use App\Helpers\Helper;
use App\Models\PackageDelivery;
use App\Models\Admin;
use Auth;

class PackageDeliveryResource extends Controller
{

    public function __construct(Request $request)
    {
      
        $this->middleware(function ($request, $next) {
        $this->id = Auth::user()->id;
        $this->email = Auth::user()->email;
        $this->admin_type = Auth::user()->admin_type;
        $this->admin_id = Auth::user()->admin_id;
        //dd($this->admin_type);
        if($this->admin_id == null){
            
             $admin = Admin::where('id','=',$this->id)->first();
           
             if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
                
             }
         } else {

            $admin = Admin::where('id','=',$this->admin_id)->first();
         
             if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
                 
             }
         }
            
        return $next($request);
    });

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $services = PackageDelivery::all();
        $admin_type = Auth::user()->admin_type;
        return view('admin.packagedelivery.index', compact('services','admin_type'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.packagedelivery.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|max:255',
            'image' => 'mimes:ico,png|dimensions:width=1024,height=1024',
        ]);

        try {
            $service = $request->all();

            if($request->hasFile('image')) {
                $service['image'] = Helper::upload_picture($request->image);
            }


            $service['status'] = 1;
            $service = PackageDelivery::create($service);

            return back()->with('flash_success','Package Type Saved Successfully');
        } catch (Exception $e) {
            dd("Exception", $e);
            return back()->with('flash_error', 'Package Type Not Found');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            return PackageDelivery::findOrFail($id);
        } catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Package Type Not Found');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $service = PackageDelivery::findOrFail($id);
            return view('admin.packagedelivery.edit',compact('service'));
        } catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Package Type Not Found');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|max:255',
            'image' => 'mimes:ico,png|dimensions:width=1024,height=1024',
        ]);

        try {

            $service = PackageDelivery::findOrFail($id);

            if($request->hasFile('image')) {
                if($service->image) {
                    Helper::delete_picture($service->image);
                }
                $service->image = Helper::upload_picture($request->image);
            }


            $service->name = $request->name;
            $service->description = $request->description;
            $service->save();

            return redirect()->route('admin.packagedelivery.index')->with('flash_success', 'Package Type Updated Successfully');    
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Package Type Not Found');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            PackageDelivery::find($id)->delete();
            return back()->with('message', 'Package Type deleted successfully');
        } catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Package Type Not Found');
        } catch (Exception $e) {
            return back()->with('flash_error', 'Package Type Not Found');
        }    
    }

    public function status($id,$status)
    {
        try {
            $screen=PackageDelivery::find($id);
            $screen->status=$status;
            $screen->save();
            return back()->with('message', 'Package Type status updated successfully');
        } catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Package Type Not Found');
        } catch (Exception $e) {
            return back()->with('flash_error', 'Package Type Not Found');
        } 
    }
}
