<?php

namespace App\Http\Controllers\Resource;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Setting;
use Exception;
use App\Helpers\Helper;
use App\Models\ServiceCategory;
use App\Models\Admin;
use Auth;
use App\Models\ServiceType;

class ServiceCategoryResource extends Controller
{
    public function __construct(Request $request)
    {
      
        $this->middleware(function ($request, $next) {
        $this->id = Auth::user()->id;
        $this->email = Auth::user()->email;
        $this->admin_type = Auth::user()->admin_type;
        $this->admin_id = Auth::user()->admin_id;
        //dd($this->admin_type);
        if($this->admin_id == null){
            
             $admin = Admin::where('id','=',$this->id)->first();
           
             if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
                
             }
         } else {

            $admin = Admin::where('id','=',$this->admin_id)->first();
         
             if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
                 
             }
         }
            
        return $next($request);
    });

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $services = ServiceCategory::all();
        $admin_type = Auth::user()->admin_type;
        return view('admin.servicecategory.index', compact('services','admin_type'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $services = ServiceType::get();
        return view('admin.servicecategory.create',compact('services'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|max:255',
            'image' => 'mimes:ico,png|dimensions:width=1024,height=1024',
        ]);

        try {
            $service = $request->all();

            if($request->hasFile('image')) {
                $service['image'] = Helper::upload_picture($request->image);
            }
            $service['status'] = 1;
            $service = ServiceCategory::create($service);
            return back()->with('flash_success','ServiceCategory Saved Successfully');
        } catch (Exception $e) {
            dd("Exception", $e);
            return back()->with('flash_error', 'ServiceCategory Not Found');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            return ServiceCategory::findOrFail($id);
        } catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'ServiceCategory Type Not Found');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $allservices = ServiceType::get();
            $service = ServiceCategory::findOrFail($id);
            return view('admin.servicecategory.edit',compact('service','allservices'));
        } catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'ServiceCategory Type Not Found');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|max:255',
            'image' => 'mimes:ico,png|dimensions:width=1024,height=1024',
        ]);

        try {

            $service = ServiceCategory::findOrFail($id);

            if($request->hasFile('image')) {
                if($service->image) {
                    Helper::delete_picture($service->image);
                }
                $service->image = Helper::upload_picture($request->image);
            }


            $service->name = $request->name;
            $service->description = $request->description;
            $service->save();

            return redirect()->route('admin.servicecategory.index')->with('flash_success', 'ServiceCategory Updated Successfully');    
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'ServiceCategory Not Found');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            ServiceCategory::find($id)->delete();
            return back()->with('message', 'ServiceCategory Type deleted successfully');
        } catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'ServiceCategory Type Not Found');
        } catch (Exception $e) {
            return back()->with('flash_error', 'ServiceCategory Type Not Found');
        }    
    }

    public function status($id,$status)
    {
        try {
            $screen=ServiceCategory::find($id);
            $screen->status=$status;
            $screen->save();
            return back()->with('message', 'ServiceCategory Type status updated successfully');
        } catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'ServiceCategory Type Not Found');
        } catch (Exception $e) {
            return back()->with('flash_error', 'ServiceCategory Type Not Found');
        } 
    }

}
