<?php

namespace App\Http\Controllers\Resource;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use Setting;
use Exception;
use App\Helpers\Helper;
use App\Models\ServiceType;
use App\Models\LocationWiseFare;
use App\Models\PoiFare;
use App\Models\Admin;
use Auth;
use App\Models\FareModel;
use App\Models\HomeScreen;

class ServiceResource extends Controller
{   

    public function __construct(Request $request)
    {
      
        $this->middleware(function ($request, $next) {
        $this->id = Auth::user()->id;
        $this->email = Auth::user()->email;
        $this->admin_type = Auth::user()->admin_type;
        $this->admin_id = Auth::user()->admin_id;
        //dd($this->admin_type);
        if($this->admin_id == null){
            
             $admin = Admin::where('id','=',$this->id)->first();
           
             if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
                
             }
         } else {

            $admin = Admin::where('id','=',$this->admin_id)->first();
         
             if($admin->admin_type != 0 && $admin->time_zone != null){
                 date_default_timezone_set($admin->time_zone);
                 
             }
         }
            
        return $next($request);
    });
        

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $services = ServiceType::all();
	    $admin_type = Auth::user()->admin_type;
        return view('admin.service.index', compact('services','admin_type'));
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $hometypes = HomeScreen::where('status',1)->get();
        return view('admin.service.create', compact('hometypes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
           // 'home_screen_id' => 'required',
            'name' => 'required|max:255',
            //'image' => 'mimes:ico,png|dimensions:width=100,height=100',
	        //'description_image' => 'mimes:ico,png|dimensions:width=100,height=100',   
        ]);

        try {
            $service = $request->all();
            // $service['home_screen_id'] = 1;

            if($request->hasFile('image')) {
                $service['image'] = Helper::upload_picture($request->image);
            }

            if($request->hasFile('description_image')) {
                $service['description_image'] = Helper::upload_picture($request->description_image);
            }

            $service['status'] = 1;
            $service = ServiceType::create($service);

            return back()->with('flash_success','Service Type Saved Successfully');
        } catch (Exception $e) {
            dd("Exception", $e);
            return back()->with('flash_error', 'Service Type Not Found');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ServiceType  $serviceType
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            return ServiceType::findOrFail($id);
        } catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Service Type Not Found');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ServiceType  $serviceType
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $hometypes = HomeScreen::where('status',1)->get();
            $service = ServiceType::findOrFail($id);
            return view('admin.service.edit',compact('service','hometypes'));
        } catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Service Type Not Found');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ServiceType  $serviceType
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $this->validate($request, [
            //'home_screen_id' => 'required',
            'name' => 'required|max:255',
            //'image' => 'mimes:ico,png|dimensions:width=512,height=512',
	        //'description_image' => 'mimes:ico,png|dimensions:width=512,height=512',
        ]);

        try {

            $service = ServiceType::findOrFail($id);

            if($request->hasFile('image')) {
                if($service->image) {
                    Helper::delete_picture($service->image);
                }
                $service->image = Helper::upload_picture($request->image);
            }
            if($request->hasFile('description_image')) {
                if($service->description_image) {
                    Helper::delete_picture($service->description_image);
                }
                $service->description_image = Helper::upload_picture($request->description_image);          
            }
            $service->home_screen_id = $request->home_screen_id;
            $service->seats_available = $request->seats_available;
            $service->name = $request->name;
            $service->vat_percent = 0;
            $service->description = $request->description;
            $service->keyword = $request->keyword;
            $service->shortcut = $request->shortcut;
            $service->save();

            return redirect()->route('admin.service.index')->with('flash_success', 'Service Type Updated Successfully');    
        } 

        catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Service Type Not Found');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ServiceType  $serviceType
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            LocationWiseFare::where('service_type_id','=',$id)->delete();
            PoiFare::where('service_type_id','=',$id)->delete();
            FareModel::where('service_type_id','=',$id)->delete();
            ServiceType::find($id)->delete();
            return back()->with('message', 'Service Type deleted successfully');
        } catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Service Type Not Found');
        } catch (Exception $e) {
            return back()->with('flash_error', 'Service Type Not Found');
        }
    }

    public function status($id,$status)
    {
        try {
            $screen=ServiceType::find($id);
            $screen->status=$status;
            $screen->save();
            return back()->with('message', 'Service Type status updated successfully');
        } catch (ModelNotFoundException $e) {
            return back()->with('flash_error', 'Service Type Not Found');
        } catch (Exception $e) {
            return back()->with('flash_error', 'Service Type Not Found');
        } 
    }
}