<?php

namespace App\Http;

use Illuminate\Foundation\Http\Kernel as HttpKernel;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array
     */
    protected $middleware = [
        // \App\Http\Middleware\TrustHosts::class,
        \App\Http\Middleware\TrustProxies::class,
        \Fruitcake\Cors\HandleCors::class,
        \App\Http\Middleware\CheckForMaintenanceMode::class,
        \App\Http\Middleware\PreventRequestsDuringMaintenance::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array
     */
    protected $middlewareGroups = [
        'web' => [
            \App\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            // \Laravel\Jetstream\Http\Middleware\AuthenticateSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            \App\Http\Middleware\HttpsProtocol::class,
            \App\Http\Middleware\WebLocalization::class,
        ],

        'api' => [
            // 'throttle:api',
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            'localization',
            // 'bindings',
        ],
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array
     */
    protected $routeMiddleware = [

        'hotel' => \App\Http\Middleware\RedirectIfNotHotel::class,
        'hotel.guest' => \App\Http\Middleware\RedirectIfHotel::class,
        'localization' => \App\Http\Middleware\Localization::class,
        'partner' => \App\Http\Middleware\RedirectIfNotPartner::class,
        'partner.guest' => \App\Http\Middleware\RedirectIfPartner::class,
        'dispatcher' => \App\Http\Middleware\RedirectIfNotDispatcher::class,
        'dispatcher.guest' => \App\Http\Middleware\RedirectIfDispatcher::class,
        'provider' => \App\Http\Middleware\RedirectIfNotProvider::class,
        'provider.guest' => \App\Http\Middleware\RedirectIfProvider::class,
        'provider.api' => \App\Http\Middleware\ProviderApiMiddleware::class,
        'account' => \App\Http\Middleware\RedirectIfNotAccount::class,
        'account.guest' => \App\Http\Middleware\RedirectIfAccount::class,
        'corporate' => \App\Http\Middleware\RedirectIfNotCorporate::class,
        'corporate.guest' => \App\Http\Middleware\RedirectIfCorporate::class,
        'customercare' => \App\Http\Middleware\RedirectIfNotCustomercare::class,
        'customercare.guest' => \App\Http\Middleware\RedirectIfCustomercare::class,
        'admin' => \App\Http\Middleware\RedirectIfNotAdmin::class,
        'admin.guest' => \App\Http\Middleware\RedirectIfAdmin::class,
        'auth' => \App\Http\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'cache.headers' => \Illuminate\Http\Middleware\SetCacheHeaders::class,
        'can' => \Illuminate\Auth\Middleware\Authorize::class,
        'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
        'password.confirm' => \Illuminate\Auth\Middleware\RequirePassword::class,
        'signed' => \Illuminate\Routing\Middleware\ValidateSignature::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
        'jwt.auth' => \Tymon\JWTAuth\Http\Middleware\Authenticate::class,
        'jwt.refresh' => \Tymon\JWTAuth\Http\Middleware\RefreshToken::class,

    ];
}
