<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CorporateDocument extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'corporate_id','document_id','url','unique_id','status','expires_at'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
         'created_at', 'updated_at'
    ];

    /**
     * The services that belong to the user.
     */
    public function corporate()
    {
        return $this->belongsTo('App\Models\Corporate');
    }
    /**
     * The services that belong to the user.
     */
    public function document()
    {
        return $this->belongsTo('App\Models\CorporateDocList');
    }
}
