<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceType extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'home_screen_id','name','image','vat_percent','status','description','seats_available','description_image','keyword','shortcut','suggest_service'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
         'created_at', 'updated_at'
    ];

    public function home_screen()
    {
        return $this->belongsTo('App\Models\HomeScreen');
    }

    public function service_category()
    {
        return $this->hasMany('App\Models\ServiceCategory', 'service_type_id');
    }

}