@extends('admin.layout.base')

@section('title', 'Update Banner')
@section('styles')
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.4/jquery.datetimepicker.min.css" />
<style>
.headtitle{
    /* padding-bottom: 2rem; */
}
.headtitle p{
    font-weight: bold;
    text-align: center;
}
.p_left{
    padding: 0 2px;
}
.row {
    display: block !important;
}
.vertical-center {
  -ms-transform: translateY(220px);
  transform: translateY(220px);
}
</style>
@endsection
@section('content')
<div class="content-area py-1">
    <div class="container-fluid">
    
        <div class="row bg-title">
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <h4 class="page-title">@lang('admin.member.banner')</h4><a href="{{ route('admin.bannerimage.index') }}" class="btn btn-outline-warning btn-rounded w-min-sm m-l-0-75 waves-effect waves-light">@lang('admin.member.list_banner')</a>
            </div>
            <div class="col-lg-6 col-sm-6 col-md-6 col-xs-12">
                <ol class="breadcrumb">
                    <li><a href="{{ route('admin.dashboard') }}">@lang('admin.dashboard')</a></li>
                    <li class="active">@lang('admin.member.banner')</li>
                </ol>
            </div>
        </div>

        <div class="box box-block bg-white">
            <form class="form-horizontal" autocomplete="off" action="{{route('admin.bannerimage.update', $service->id )}}" method="POST" enctype="multipart/form-data" role="form">
                <h5>@lang('admin.member.add_package_delivery')</h5>
                    {{ csrf_field() }}
                <input type="hidden" name="_method" value="PATCH">
                <div class="form-group row">
                    <label for="name" class="col-xs-12 col-form-label">@lang('admin.member.add_banner')</label>
                    <div class="col-xs-8">
                        <input class="form-control" type="text" value="{{ $service->name }}" name="name" required id="name" placeholder="@lang('admin.member.service_name')">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="name" class="col-xs-12 col-form-label">Banner Expire Date</label>
                    <div class="col-xs-8">
                        <input class="form-control" type="date" value="{{ $service->expire_date }}"  min="<?php echo date('Y-m-d'); ?>" name="expire_date" required id="expire_date" placeholder="">
                    </div>
                </div>
                <div class="form-group row">
                
                <label for="image" class="col-xs-12 col-form-label">@lang('admin.member.banner_image')</label>
                <div class="col-xs-8">
                    @if(isset($service->image))
                    <img style="height: 120px; width: 120px; margin-bottom: 15px; border-radius:2em;" src="{{ $service->image }}">
                    @endif
                    <input type="file" accept="image/*" name="image" class="dropify form-control-file" id="image" aria-describedby="fileHelp">
                </div>
                <div class="col-xs-2 vertical-center">
                    <a href="#" data-toggle="modal" class="imginfo"><img src="/asset/img/Info.svg" alt="Image Instruction" style="width:22px;"/></a>
                </div>
                <div class="row">
                    <label for="picture" class="col-xs-12 col-form-label">@lang('admin.member.description')</label>
                    <div class="col-xs-8">
                    <textarea class="form-control" name="description" required id="description" placeholder="@lang('admin.member.description')" rows="4">{{ $service->description }}</textarea>
                    </div>
                </div> 

            </div>
                <button type="submit" class="btn btn-success"> <i class="fa fa-check"></i> Update Banner</button>
                <a href="{{ route('admin.bannerimage.index') }}" class="btn btn-inverse waves-effect waves-light">@lang('admin.member.cancel')</a>   
            </form>
        </div>
    </div>
</div>

@endsection