@extends('admin.layout.base')

@section('title', 'Complaints')

@section('content')
<div class="content-area py-1">
    <div class="container-fluid">

        <div class="row bg-title">
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <h4 class="page-title">Complaints</h4>
            </div>
        </div>

        <div class="box box-block bg-white">
            <table class="table table-striped table-bordered dataTable" id="table-2">
                <thead>
                    <tr>
                        <th>@lang('admin.member.id')</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Complaint type</th>
                        <th>Complaint Description</th>
                        <th>Created at</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($complaints as $index => $complaint)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $complaint->name }}</td>
                        <td>{{ $complaint->email }}</td>
                        <td>{{ $complaint->phone }}</td>
                        <td>{{ $complaint->complaint_type }}</td>
                        <td>{{ $complaint->complaint_desc }}</td>
                        <td>{{ $complaint->created_at }}</td>
                        <td>
                           <form action="{{ route('admin.complaint.destroy', $complaint->id) }}" method="POST">
                                {{ csrf_field() }}
                                <input type="hidden" name="_method" value="DELETE">
                                <button class="btn btn-danger btn-rounded label-left b-a-0 waves-effect waves-light" onclick="return confirm('Are you sure?')"><span class="btn-label"><i class="fa fa-trash"></i></span> @lang('admin.member.delete')</button>
                            </form> 
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th>@lang('admin.member.id')</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Complaint type</th>
                        <th>Complaint Description</th>
                        <th>Created at</th>
                        <th>Action</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>

@endsection
