@extends('admin.layout.base')

@section('title', 'Add Fare Model ')
@section('styles')
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.4/jquery.datetimepicker.min.css" />
<style>
.headtitle{
    /* padding-bottom: 2rem; */
}
.headtitle p{
    font-weight: bold;
    text-align: center;
}
.p_left{
    padding: 0 2px;
}
.row {
    display: block !important;
}
</style>
@endsection
@section('content')
<div class="content-area py-1">
    <div class="container-fluid">
    
        <div class="row bg-title">
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <h4 class="page-title">Fare Management</h4><a href="{{ route('admin.faremodel.index') }}" class="btn btn-outline-warning btn-rounded w-min-sm m-l-0-75 waves-effect waves-light">List Fare model</a>
            </div>
            <div class="col-lg-6 col-sm-6 col-md-6 col-xs-12">
                <ol class="breadcrumb">
                    <li><a href="{{ route('admin.dashboard') }}">@lang('admin.dashboard')</a></li>
                    <li class="active">Add fare model</li>
                </ol>
            </div>
        </div>
    <form class="form-horizontal" autocomplete="off" action="{{route('admin.faremodel.store')}}" method="POST" enctype="multipart/form-data" role="form">
    <div class="row">
        <div class="box box-block bg-white">
            <h5>Add Fare Model</h5>
                {{ csrf_field() }}
            <!-- <div class="form-group row">
                <label for="country_id" class="col-xs-2 col-form-label">Country</label>
                <div class="col-xs-6">
                    <select name="country_id" id="country_id" required="required" class="form-control">
                        <option value="">Select Country</option>
                        @foreach($countries as $country)
                            <option value="{{ $country->countryid }}">{{ $country->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div> -->
            
            <div class="form-group row">
                <label for="timezoner" class="col-xs-12 col-form-label">Service Types</label>
                <div class="col-xs-8">
                <select name="service_type_id" id="service_type_id" required="required" class="form-control get_category">
                    <option value="">Select Service</option>
                    @foreach($services as $service)
                    <option value="{{ $service->id }}">{{ $service->name }}</option>
                    @endforeach
                </select>                   
               </div>
            </div>

            <!-- <div class="form-group row" >
                <div class="view_category" style="display: none;">
                <label for="timezoner" class="col-xs-12 col-form-label">Category</label>
                <div class="col-xs-8">
                <select name="category_id" id="category_id" required="required" class="form-control set_category">                   
                </select>                   
               </div>
                </div>
            </div> -->

           

            <div class="form-group row">
                <label for="s1_enable" class="col-xs-12 col-form-label">Service Fare ({{ currency() }})</label>
                <div class="col-xs-8">
                <input class="form-control" type="text" value="{{ old('service_fare') }}" name="service_fare" required id="service_fare" placeholder="Service Price">
                </div>
            </div>

          

            </div>
            
            <div class="row">
                <div class="box box-block bg-white">
                <button type="submit" class="btn btn-success" @if(Auth::user()->id!=1) disabled @endif> <i class="fa fa-check"></i> Add Fare Model</button>
                        <a href="{{ route('admin.faremodel.index') }}" class="btn btn-inverse waves-effect waves-light">@lang('admin.member.cancel')</a>
                </div>
            </div>
            
        </form>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.4/build/jquery.datetimepicker.full.min.js"></script>
<script type="text/javascript">


$('#service_fare').prop('required',false);
            $('#t1_stime').prop('required',false);
            $('#t2_stime').prop('required',false);
            $('#t1_etime').prop('required',false);
            $('#t2_etime').prop('required',false);

            $('#t1_base').prop('required',false);
            $('#t2_base').prop('required',false);
            $('#t1_base_dist').prop('required',false);
            $('#t2_base_dist').prop('required',false);
            $('#t1_distance').prop('required',false);
            $('#t2_distance').prop('required',false);
            $('#t1_minute').prop('required',false);
            $('#t2_minute').prop('required',false);
            

            $('#t1_waiting').prop('required',false);
            $('#t2_waiting').prop('required',false);
            $('#t1_s_stime').prop('required',false);
            $('#t2_s_stime').prop('required',false);
            $('#t1_s_etime').prop('required',false);
            $('#t2_s_etime').prop('required',false);
            $('#t1_s_base').prop('required',false);
            $('#t2_s_base').prop('required',false);
            $('#t1_s_base_dist').prop('required',false);
            $('#t2_s_base_dist').prop('required',false);
            $('#t1_s_distance').prop('required',false);
            $('#t2_s_distance').prop('required',false);
            $('#t1_s_minute').prop('required',false);
            $('#t1_s_minute').prop('required',false);
            $('#t2_s_minute').prop('required',false);

            $('#t1_s_waiting').prop('required',false);
            $('#t2_s_waiting').prop('required',false);
            $('#s1_waiting').prop('required',false);
            $('#s2_waiting').prop('required',false);

            $('#s3_waiting').prop('required',false);
            $('#s4_waiting').prop('required',false);
            $('#t1_base_wait').prop('required',false);
            $('#t2_base_wait').prop('required',false);
            $('#t1s_base_wait').prop('required',false);
            $('#t2s_base_wait').prop('required',false);

            $('#t2s_base_wait').prop('required',false);
            $('#t2s_base_wait').prop('required',false);
            $('#t2s_base_wait').prop('required',false);
            $('#t2s_base_wait').prop('required',false);
            $('#t2s_base_wait').prop('required',false);
            $('#t3_base_wait').prop('required',false);
            $('#t4_base_wait').prop('required',false);
            $('#t3s_base_wait').prop('required',false);
            $('#t4s_base_wait').prop('required',false);
            $('#s1_stime').prop('required',false);
            $('#s2_stime').prop('required',false);
            $('#s1_percent').prop('required',false);
            $('#s2_percent').prop('required',false);
            $('#s1_etime').prop('required',false);
            $('#s2_etime').prop('required',false);

    $('#t1_stime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });
    $('#t2_stime').datetimepicker({
         datepicker:false,
         format:'H:i', 
         step:5
    });
    $('#t3_stime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });
    $('#t4_stime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });

    $('#t1_etime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });
    $('#t2_etime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });
    $('#t3_etime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });
    $('#t4_etime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });


    //  $('#t1_s_stime').datetimepicker({
    //      datepicker:false,
    //      format:'H:i',
    //      step:5
    //});
    $('#t2_s_stime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });
    $('#t3_s_stime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });
    $('#t4_s_stime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });

    $('#t1_s_etime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });
    $('#t2_s_etime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });
    $('#t3_s_etime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });
    $('#t4_s_etime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });

    $('#s1_stime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });
    $('#s2_stime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });
    $('#s1_etime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });
    $('#s2_etime').datetimepicker({
         datepicker:false,
         format:'H:i',
         step:5
    });

    function overlapp(){
        var dateRanges = [];
        if($('#t1_stime').val()!=''){ dateRanges.push(sec_convert($('#t1_stime').val())); }
        if($('#t1_etime').val()!=''){ dateRanges.push(sec_convert($('#t1_etime').val())); }
        if($('#t2_stime').val()!=''){ dateRanges.push(sec_convert($('#t2_stime').val())); }
        if($('#t2_etime').val()!=''){ dateRanges.push(sec_convert($('#t2_etime').val())); }
        if($('#t3_stime').val()!=''){ dateRanges.push(sec_convert($('#t3_stime').val())); }
        if($('#t3_etime').val()!=''){ dateRanges.push(sec_convert($('#t3_etime').val())); }
        if($('#t4_stime').val()!=''){ dateRanges.push(sec_convert($('#t4_stime').val())); }
        if($('#t4_etime').val()!=''){ dateRanges.push(sec_convert($('#t4_etime').val())); }
        if($('#s1_stime').val()!=''){ dateRanges.push(sec_convert($('#s1_stime').val())); }
        if($('#s2_stime').val()!=''){ dateRanges.push(sec_convert($('#s2_stime').val())); }
        if($('#s1_etime').val()!=''){ dateRanges.push(sec_convert($('#s1_etime').val())); }
        if($('#s2_etime').val()!=''){ dateRanges.push(sec_convert($('#s2_etime').val())); }

        var length = dateRanges.length - 1;
        for (var i = 1; i < length; i++){
          var previous = dateRanges[i-1];
          var current = dateRanges[i];
          if(previous > current){
            $('#overlapp_txt').text('Time is overlapping');
          }else{
            $('#overlapp_txt').text('');
          }
        }
    }

    function sec_convert(data){
        var hms = data; 
        var a = hms.split(':');
        var seconds = (+a[0]) * 60 * 60 + (+a[1]) * 60 + (+a[2]); 
    }

    
    $('.get_category').on('change', function() {

        $(".view_category").css("display", "none");

        if(this.value==7)
        {
            
            $.ajax({
            type: 'GET',
            
            url: `{{url('/')}}/admin/get-category/`+this.value,   
            success: function(data1) {

                $('.set_category').html(data1);

                $('.view_category').css('display','block');
            }
            });
        }
    });
</script>
@endsection