@extends('admin.layout.base')

@section('title', 'Location ')

@section('styles')
<style>
.scroller thead, .scroller tbody { display: block; }
.table thead th{
    border: none;
}
.scroller tbody  {
    height: 700px;       /* Just for the demo          */
    overflow-y: auto;    /* Trigger vertical scroll    */
    overflow-x: hidden;  /* Hide the horizontal scroll */
}
.scroller tr{
    display: block;
    border-top: 1px solid #eceeef;
}
.scroller td, th{
    border: none;
}
#providers{
    cursor: pointer;
}
#timers{
    cursor: pointer;
}
#timers td{
    font-size: 12px;
}
</style>
@endsection

@section('content')
<div class="content-area py-1" id="trip-panel">
    <div class="container-fluid">
        <div class="row bg-title">
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <h4 class="page-title">Drivers Location</h4>
            </div>
            <div class="col-lg-6 col-sm-6 col-md-6 col-xs-12">
                <ol class="breadcrumb">
                    <li><a href="{{ route('admin.dashboard') }}">@lang('admin.dashboard')</a></li>
                </ol>
            </div>
        </div>
        <div class="row">
            <div class="col-md-3">
                <div class="box-block bg-white">
                    <table class="table scroller providers">
                        <thead>
                            <tr>
                                <th>Name</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($providers as $index => $provider)
                            <tr id="providers" data-id="{{ $provider->id }}">
                                <td>{{ $provider->name }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-md-2">
                <div class="box-block bg-white">
                    <table class="table scroller timers">
                        <thead>
                            <tr>
                                <th>
                                    Time
                                </th>
                            </tr>
                        </thead>
                        <tbody id="timeblock">
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-md-7">
                <div class="box-block bg-white">
                    <div id="map" style="height: 740px;"></div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="https://maps.googleapis.com/maps/api/js?key={{ Setting::get('map_key', 'AIzaSyC7urojphmUg5qlseNH99Rojwn9Y-Amc0w') }}&libraries=places"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $("body").addClass("compact-sidebar");
        $('[data-toggle="tooltip"]').tooltip();
    });
    $(document).ready(function () {
        $('.providers tr').click(function () {
            $('.providers tr').css('background','white');
            //Check to see if background color is set or if it's set to white.
            if(this.style.background == "" || this.style.background =="white") {
                $(this).css('background', '#ffefd1');
            }
            else {
                $(this).css('background', 'white');
            }
        });
    });
</script>
<script>
    $(window).load(function(){
        worldMapInitialize();
    });
    $(document).on('click','#providers', function(){
        var provider_id = $(this).attr("data-id");
        time_updates(provider_id);
        setInterval(function(){
            time_updates(provider_id);
            }, 120000);
    });

    function time_updates(id){
        var dataString = "provider_id="+id;
        $.ajax
            ({
              cache: false,
              type: "GET",
              url: "{{ route('admin.timelist')}}",
              data: dataString,
              success: function(data)
              {
                 $('#timeblock').html(data);
              }
            });
    }
</script>

<script>
    var map;
    var latitude;
    var longitude;
    var zooming;
    var googleMarkers = [];
    var mapIcons = "{{asset('asset/img/track_car.png')}}";
    function worldMapInitialize() {
        
        latitude = parseFloat("{{ Setting::get('address_lat', '') }}");
        longitude = parseFloat("{{ Setting::get('address_long', '') }}");
        zooming = parseInt("{{ Setting::get('zoom', '') }}");
            
        map = new google.maps.Map(document.getElementById('map'), {
            center: {lat: latitude, lng: longitude},
            zoom: zooming,
            mapTypeControl: true,
              mapTypeControlOptions: {
                  style: google.maps.MapTypeControlStyle.SMALL,
                  position: google.maps.ControlPosition.TOP_CENTER,
                  mapTypeIds: ['roadmap', 'satellite']
              },
              zoomControl: true,
              zoomControlOptions: {
                style: google.maps.ZoomControlStyle.SMALL,
                position: google.maps.ControlPosition.BOTTOM_CENTER
              }     
        });

    }

    $(document).on('click','#timers', function(){

        for (var i = 0; i < googleMarkers.length; i++ ) {
                googleMarkers[i].setMap(null);
            }
        googleMarkers.length = 0;

        var lat = parseFloat($(this).attr("data-lat"));
        var lng = parseFloat($(this).attr("data-long"));
    
        marker = new google.maps.Marker({
            position: {
                lat: lat,
                lng: lng
            },
            map: map,
            icon : mapIcons,
        });
        map.setZoom(17);
        map.panTo(marker.getPosition());
        googleMarkers.push(marker);
    });
</script>
@endsection