@extends('admin.layout.base')

@section('title', 'Package Types')

@section('styles')
<style>
	.not-allowed {
     		pointer-events: auto !important;
     		cursor: not-allowed !important;
	}
</style>
@endsection

@section('content')
<div class="content-area py-1">
    <div class="container-fluid">

        <div class="row bg-title">
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <h4 class="page-title">@lang('admin.member.package_delivery')</h4><a href="{{ route('admin.packagedelivery.create') }}" class="btn btn-outline-warning btn-rounded w-min-sm m-l-0-75 waves-effect waves-light">@lang('admin.member.add_package_delivery')</a>
            </div>
            <div class="col-lg-6 col-sm-6 col-md-6 col-xs-12">
                <ol class="breadcrumb">
                    <li><a href="{{ route('admin.dashboard') }}">@lang('admin.dashboard')</a></li>
                    <li class="active">@lang('admin.list_package_delivery')</li>
                </ol>
            </div>
        </div>

        <div class="box box-block bg-white">
            <table class="table table-striped table-bordered dataTable" id="table-2">
                <thead>
                    <tr>
                        <th>@lang('admin.member.id')</th>
                        <th>@lang('admin.member.package_name')</th>
                        <th>@lang('admin.member.package_image')</th>
                        <th>@lang('admin.member.action')</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($services as $index => $service)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $service->name }}</td>
                        <td>
                            @if($service->image) 
                                <img src="{{$service->image}}" style="height: 50px" >
                            @else
                                N/A
                            @endif
                        </td>
                        <td>
                           
				@if($admin_type == 1)
                                <a href="#" class="btn btn-success btn-rounded btn-sm label-left b-a-0 waves-effect waves-light @if($admin_type == 1) disabled not-allowed @endif ">
                                    <span class="btn-label"><i class="fa fa-pencil"></i></span> @lang('admin.member.edit')
                                </a>
				@else
					<a href="{{ route('admin.packagedelivery.edit', $service->id) }}" class="btn btn-success btn-rounded btn-sm label-left b-a-0 waves-effect waves-light @if($admin_type == 1) disabled not-allowed @endif ">
                                    <span class="btn-label"><i class="fa fa-pencil"></i></span> @lang('admin.member.edit')
                                </a>
				@endif
				@if($service->status == 1) 
					<a href="{{ route('admin.packagedelivery.status', ['id' => $service->id, 'status' => 0]) }}"><button class="btn btn-danger btn-sm btn-rounded b-a-0 waves-effect waves-light" onclick="return confirm('Are you sure?')">
                    Disable</button></a>
                @else
                <a href="{{ route('admin.packagedelivery.status', ['id' => $service->id, 'status' => 1]) }}"><button class="btn btn-success btn-sm btn-rounded b-a-0 waves-effect waves-light" onclick="return confirm('Are you sure?')">
                    Enable</button></a>
				@endif
                            
                        </td>
                    </tr>
                @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th>@lang('admin.member.id')</th>
                        <th>@lang('admin.member.package_name')</th>
                        <th>@lang('admin.member.package_image')</th>
                        <th>@lang('admin.member.action')</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script type="text/javascript">
	$( document ).ready(function() {
   		console.log( "ready!" );
		//$('.not-allowed').attr("href", "#");
	});
</script>
@endsection