@extends('admin.layout.base')

@section('title', 'Add Service Type ')
@section('styles')
<style>
.headtitle{
    /* padding-bottom: 2rem; */
}
.headtitle p{
    font-weight: bold;
    text-align: center;
}
.p_left{
    padding: 0 2px;
}
.vertical-center {
  -ms-transform: translateY(45%);
  transform: translateY(45%);
}
.not-allowed {
     		pointer-events: auto !important;
     		cursor: not-allowed !important;
	}

</style>
@endsection
@section('content')
<div class="content-area py-1">
    <div class="container-fluid">
    
        <div class="row bg-title">
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <h4 class="page-title">@lang('admin.member.service_types')</h4><a href="{{ route('admin.service.index') }}" class="btn btn-outline-warning btn-rounded w-min-sm m-l-0-75 waves-effect waves-light">@lang('admin.list_service_types')</a>
            </div>
            <div class="col-lg-6 col-sm-6 col-md-6 col-xs-12">
                <ol class="breadcrumb">
                    <li><a href="{{ route('admin.dashboard') }}">@lang('admin.dashboard')</a></li>
                    <li class="active">@lang('admin.member.add_service_type')</li>
                </ol>
            </div>
        </div>
        <div class="box box-block bg-white">
            <form class="form-horizontal" autocomplete="off" action="{{route('admin.service.store')}}" method="POST" enctype="multipart/form-data" role="form">
                <h5>@lang('admin.member.add_service_type')</h5>
                    {{ csrf_field() }}
                <div class="form-group row">  
                    <label for="timezoner" class="col-xs-12 col-form-label">Home Types</label>
                    <div class="col-xs-8">
                    <select name="home_screen_id" id="home_screen_id" required="required" class="form-control">
                        <option value="">Home Types</option>
                        @foreach($hometypes as $hometype)
                        <option value="{{ $hometype->id }}">{{ $hometype->name }}</option>
                        @endforeach
                    </select>                   
                   </div>
                </div>
                <div class="form-group row">
                    <label for="name" class="col-xs-12 col-form-label">@lang('admin.member.service_name')</label>
                    <div class="col-xs-8">
                        <input class="form-control" type="text" value="{{ old('name') }}" name="name" required id="name" placeholder="@lang('admin.member.service_name')">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="seats_available" class="col-xs-12 col-form-label">Seats Available</label>
                    <div class="col-xs-8">
                        <input class="form-control" type="number" value="{{ old('seats_available') }}" name="seats_available" required id="seats_available" placeholder="Seats Available">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="picture" class="col-xs-12 col-form-label">@lang('admin.member.service_image')</label> 
                    <div class="col-xs-8">
                        <input type="file" accept="image/*" name="image" class="dropify form-control-file" id="picture" aria-describedby="fileHelp">
                    </div>
		    <div class="col-xs-2 vertical-center">
                        <a href="#" data-toggle="modal" class="imginfo"><img src="/asset/img/Info.svg" title="The  image size is (100 x 100). This size is suitable for mobile devices and all sizes of screen views." alt="Image Instruction" style="width:22px;"/></a>
                    </div>
                </div> 
                <div class="form-group row">
                    <label for="picture" class="col-xs-12 col-form-label">Description</label>
                    <div class="col-xs-8">
                    <textarea class="form-control" value="{{ old('description') }}" name="description" required id="description" placeholder="@lang('admin.member.description')" rows="4"></textarea>
                    </div>
                </div> 
                <div class="form-group row">
                    <label for="picture" class="col-xs-12 col-form-label">Description Image</label>
                    <div class="col-xs-8">
                        <input type="file" accept="image/*" name="description_image" class="dropify form-control-file" id="description_image" aria-describedby="fileHelp">
                    </div>
		    <div class="col-xs-2 vertical-center">
                        <a href="#" data-toggle="modal" class="imginfo"><img src="/asset/img/Info.svg" alt="Image Instruction" style="width:22px;"/></a>
                    </div>
                </div> 

                 <div class="form-group row">
                    <label for="keyword" class="col-xs-12 col-form-label">Keywords</label>
                    <div class="col-xs-8">

                          <textarea class = "form-control" rows = "3" name="keyword" required id="keyword" placeholder = "Keywords">{{ old('keyword') }}</textarea>
                        <!-- <input class="form-control" type="text" value="{{ old('keyword') }}" name="keyword" required id="keyword" placeholder="Keywords"> -->
                    </div>
                </div>

                <div class="form-group row">
                    <label for="shortcut" class="col-xs-12 col-form-label">Shortcut</label>
                    <div class="col-xs-8">
                        <input class="form-control" type="text" value="{{ old('shortcut') }}" name="shortcut"  id="shortcut" placeholder="Shortcut">
                    </div>
                </div>
		@if(auth()->user()->admin_type != 0) 
                <button type="button" class="btn btn-success disabled not-allowed"> <i class="fa fa-check"></i> @lang('admin.member.add_service_type')</button>
		@else
		<button type="submit" class="btn btn-success"> <i class="fa fa-check"></i> @lang('admin.member.add_service_type')</button>
		@endif
                <a href="{{ route('admin.service.index') }}" class="btn btn-inverse waves-effect waves-light">@lang('admin.member.cancel')</a>   
            </form>
        </div>
    </div>
</div>

<div class="modal fade" tabindex="-1" role="dialog" id="waletmodal">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">Image Upload Condition</h4>
      </div>   
        <div class="modal-body">
            <label for="ex2">The service image size is (1024 x 1024). This size is suitable for mobile devices and all sizes of screen views. </label>
      </div>
      <!--<div class="modal-footer">
         <button type="button" data-dismiss="modal" class="close btn btn-sm justify mx-auto">Close</button>
         </div>-->
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

@endsection

@section('scripts')
<script>
    $(document).on('click','.imginfo', function() {
        $('#waletmodal').modal("show");
        });
</script>
@endsection