<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserApiController;
use App\Http\Controllers\Resource\CardResource;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

Route::get('income',[SendPushNotification::class, 'IncomingTrip']);

Route::get('/stripekey',[UserApiController::class, 'stripe_key']);
Route::get('/mapkey',[UserApiController::class, 'map_key']);
Route::post('/mobile',[UserApiController::class, 'send_mobile']);


Route::post('/login',[UserApiController::class, 'login']);
Route::post('/signup',[UserApiController::class, 'signup']);


//Route::post('/mobile',[UserApiController::class, 'send_mobile']);
Route::post('otp',[UserApiController::class, 'otp_verify']);

Route::post('/resend',[UserApiController::class, 'resend_otp']);
Route::post('/forgot/password',[UserApiController::class, 'forgot_password']);

Route::post('/reset/password',[UserApiController::class, 'reset_password']);


Route::get('/cardkey','Resource\CardResource@customer_key');

Route::get('/help',[UserApiController::class, 'help_details']);

Route::get('available/providers/{id}',[UserApiController::class, 'available_providers']);

Route::group(['middleware' => ['auth:api']], function () {
	Route::get('services',[UserApiController::class, 'services']);
	Route::get('/fare',[UserApiController::class, 'fare_model']);
	Route::get('/estimated/fare',[UserApiController::class, 'estimated_fare']);
	Route::get('logout',[UserApiController::class, 'logout']);
	Route::post('/change/password',[UserApiController::class, 'change_password']);
	Route::get('details',[UserApiController::class, 'details']);
	Route::post('/update/profile',[UserApiController::class, 'update_profile']);
	Route::get('/countries' , 'UserApiController@country_list');
	Route::post('/update/location' , 'UserApiController@update_location');
	Route::resource('card', 'Resource\CardResource');
	Route::post('/complaint' , 'UserApiController@complaint');

	Route::get('user-notes',[UserApiController::class, 'usernotes']);
	Route::get('user-ratings',[UserApiController::class, 'userratings']);

	// Trip based Apis
	// Route::post('/send/request', 'UserApiController@send_request');
	Route::post('/send/request',[UserApiController::class, 'send_request']);
	Route::post('/repeat/request', 'UserApiController@repeat_request');
	Route::post('/cancel/request', 'UserApiController@cancel_request');
	Route::post('/status' , 'UserApiController@status');
	Route::get('/started/detail', 'UserApiController@start_detail');
	Route::get('/arrived/detail', 'UserApiController@arrived_detail');
	Route::get('/pickedup/detail', 'UserApiController@pickedup_detail');
	Route::get('/dropped/detail', 'UserApiController@dropped_detail');
	Route::post('/rate/provider' , 'UserApiController@rate_provider');
	Route::get('/past/trips' , 'UserApiController@past_trips');
	Route::post('/all/trips',[UserApiController::class, 'all_trips']);
	Route::post('/past/detail/{id}', 'UserApiController@past_details');
	Route::get('/scheduled/trips' , 'UserApiController@scheduled_trips');
	Route::post('/scheduled/detail/{id}', 'UserApiController@scheduled_details');
	Route::post('/invoice-copy',[UserApiController::class, 'invoice_copy']);
	
	// payment
	Route::get('/payment_mode', 'PaymentController@payment_mode');
	Route::post('/payment' , 'PaymentController@payment');
	Route::post('/add/money' , 'PaymentController@add_money');
	Route::get('/get_pendingdue', 'PaymentController@get_pendingdue');
	Route::post('/pay_pendingdue', 'PaymentController@pay_pendingdue');

	// promocode
	Route::get('/promocodes' , 'UserApiController@promocodes');
	Route::get('/promocode/list' , 'UserApiController@list_promocode');
	Route::post('/promocode/add' , 'UserApiController@add_promocode');
	Route::get('/clear/status' , 'UserApiController@clear_status');
	Route::get('/pushnotification',[UserApiController::class, 'pushnotification']);

	// address
    Route::get('/address/list' , 'UserApiController@address_list');
	Route::get('/address/order' , 'UserApiController@addres_order');
	Route::post('/address/add' , 'UserApiController@address_add');
	Route::post('/address/update' , 'UserApiController@address_update');
	Route::get('/address/delete/{id}' , 'UserApiController@address_delete');
	Route::get('/address/default/{id}' , 'UserApiController@address_default');

	Route::post('/user-care',[UserApiController::class, 'usercare']);
	Route::get('/user-care',[UserApiController::class, 'getusercare']);

	Route::get('/contact/list' , 'UserApiController@contact_list');
	Route::post('/contact/add' , 'UserApiController@add_contact');
	Route::post('/contact/delete' , 'UserApiController@delete_contact');

	Route::post('/fav/provider',[UserApiController::class, 'fav_driver']);
	Route::get('/tips',[UserApiController::class, 'tips']);
	Route::get('/stops',[UserApiController::class, 'stops']);

	Route::get('/packagelist-list',[UserApiController::class, 'packagelist']);
	Route::get('/homescreen',[UserApiController::class, 'homescreen']);
	Route::post('/home/type',[UserApiController::class, 'home_type']);

	Route::post('/delete',[UserApiController::class, 'delete']);

});