<?php

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Authentication
Route::post('/register' , 'ProviderAuth\TokenController@register');
Route::post('/oauth/token' , 'ProviderAuth\TokenController@authenticate');
Route::post('/logout' , 'ProviderAuth\TokenController@logout');
Route::post('/mobile' , 'ProviderAuth\TokenController@send_mobile');
Route::get('/services' , 'ProviderAuth\TokenController@service');

Route::post('/forgot/password',     'ProviderAuth\TokenController@forgot_password');
Route::post('/reset/password',      'ProviderAuth\TokenController@reset_password');
Route::get('/help' , 'ProviderAuth\TokenController@help_details');
Route::get('/testpushnotification' , 'ProviderResources\TripController@testpushnotificationsss');
Route::get('/mapkey' , 'ProviderResources\TripController@map_key');

Route::group(['middleware' => ['provider.api']], function () {

	Route::group(['prefix' => 'profile'], function () {
        Route::get ('/' , 'ProviderResources\ProfileController@index');
        Route::post('/' , 'ProviderResources\ProfileController@update');
        Route::post('/password' , 'ProviderResources\ProfileController@password');
        Route::post('/location' , 'ProviderResources\ProfileController@location');
        Route::post('/available' , 'ProviderResources\ProfileController@available');

        Route::post('/upload', 'ProviderResources\ProfileController@upload_document');
        Route::post('/delete', 'ProviderResources\ProfileController@destroy_document');
        Route::get('/documents', 'ProviderResources\ProfileController@get_documents');
    });

	Route::post('/refresh/token' , 'ProviderAuth\TokenController@refresh_token');
    Route::post('/vehicle_update' , 'ProviderResources\TripController@update_vehicle');

    Route::post('/gps', 'ProviderResources\TripController@gps_location');
    Route::resource('card', 'Resource\ProviderCardResource');
    Route::get('/get_pendingdue', 'ProviderPaymentController@get_pendingdue');
    Route::post('/pay_pendingdue', 'ProviderPaymentController@pay_pendingdue');
    Route::get('/pushNotification' , 'ProviderResources\TripController@pushNotification');
    Route::get('/streetride/fare', 'ProviderResources\StreetController@streetride_fare');
    Route::post('/streetride/request', 'ProviderResources\StreetController@streetride_request');
    Route::get('/list_services', 'ProviderResources\StreetController@services');
    Route::post('/additional/fare', 'ProviderResources\TripController@additional_fare');
    Route::post('/payment/update', 'ProviderResources\TripController@payment_update');
    Route::post('/update/destination', 'ProviderResources\TripController@update_destination');
    Route::post('/summary', 'ProviderResources\TripController@summary');
    Route::get('/earnings', 'ProviderResources\TripController@earnings');
    Route::get('/earning/details', 'ProviderResources\TripController@earning_details');
    Route::post('/invoice-copy', 'ProviderResources\TripController@invoice_copy');
    Route::get('/contact/list' , 'ProviderResources\TripController@contact_list');
    Route::post('/contact/add' , 'ProviderResources\TripController@add_contact');
    Route::post('/contact/delete' , 'ProviderResources\TripController@delete_contact');
    Route::post('/delete','ProviderAuth\TokenController@delete');

    
	Route::group(['prefix' => 'requests'], function () {
    Route::post('/status' , 'ProviderResources\TripController@status');
    Route::get('/destroy/{id}' , 'ProviderResources\TripController@destroy_notification');
    Route::get('/offered' , 'ProviderResources\TripController@offered_trips');
    Route::post('/offered/{id}', 'ProviderResources\TripController@offered_details');
    Route::post('/accept/{id}', 'ProviderResources\TripController@accept_trips');
    Route::post('/cancel', 'ProviderResources\TripController@cancel_trips');
    Route::get('/planned' , 'ProviderResources\TripController@planned_trips');
    Route::post('/planned/{id}', 'ProviderResources\TripController@planned_details');
    Route::get('/scheduled' , 'ProviderResources\TripController@scheduled_trips');
    Route::post('/scheduled/{id}', 'ProviderResources\TripController@scheduled_details');
    Route::get('/completed' , 'ProviderResources\TripController@completed_trips');
    Route::post('/completed/{id}', 'ProviderResources\TripController@completed_details');
    Route::get('/past/trips' , 'ProviderResources\TripController@past_trips');
    Route::post('/past/detail/{id}', 'ProviderResources\TripController@past_details');
    Route::get('/searching/detail', 'ProviderResources\TripController@searching_detail');
    Route::post('/started/{id}', 'ProviderResources\TripController@start_trips');
    Route::get('/started/detail', 'ProviderResources\TripController@start_detail');
    Route::post('/arrived/{id}', 'ProviderResources\TripController@arrived_trips');
    Route::get('/arrived/detail', 'ProviderResources\TripController@arrived_detail');
    Route::post('/pickedup/{id}', 'ProviderResources\TripController@pickedup_trips');
    Route::get('/pickedup/detail', 'ProviderResources\TripController@pickedup_detail');
    Route::post('/dropped/{id}', 'ProviderResources\TripController@dropped_trips');
    Route::get('/dropped/detail', 'ProviderResources\TripController@dropped_detail');
    Route::post('/end/{id}', 'ProviderResources\TripController@end_trips');
    Route::get('/end/detail', 'ProviderResources\TripController@end_detail');
    Route::post('/rate/{id}', 'ProviderResources\TripController@rate');
    Route::post('/all/trips', 'ProviderResources\TripController@all_trips');
    Route::post('/clear/status', 'ProviderResources\TripController@clear_status');
    });
});

