<?php $__env->startSection('title', 'Users '); ?>

<?php $__env->startSection('content'); ?>
<div class="content-area py-1">
    <div class="container-fluid">

        <div class="row bg-title">
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <h4 class="page-title"><?php echo app('translator')->get('admin.member.users'); ?></h4><a href="<?php echo e(route('admin.user.create')); ?>" class="btn btn-outline-warning btn-rounded w-min-sm m-l-0-75 waves-effect waves-light"><?php echo app('translator')->get('admin.member.add_new_user'); ?></a>
            </div>
            <div class="col-lg-6 col-sm-6 col-md-6 col-xs-12">
                
                <ol class="breadcrumb">
                    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo app('translator')->get('admin.dashboard'); ?></a></li>
                    <li class="active"><?php echo app('translator')->get('admin.list_users'); ?></li>
                </ol>
            </div>
        </div>

        <div class="box box-block bg-white">
            <table class="table table-striped table-bordered dataTable" id="user-list">
                <thead>
                    <tr>
                        <th><?php echo app('translator')->get('admin.member.id'); ?></th>
                        <th><?php echo app('translator')->get('admin.member.name'); ?></th>
                        <th><?php echo app('translator')->get('admin.member.email'); ?></th>
                        <th><?php echo app('translator')->get('admin.member.mobile'); ?></th>
                        <th><?php echo app('translator')->get('admin.member.rating'); ?></th>
                        <th>Corporate</th>
                        <th><?php echo app('translator')->get('admin.member.action'); ?></th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    function update_content(){
        $('#user-list').DataTable({
            "destroy": true,
            "responsive": true,
            "scrollX": false,
            "dom": 'Bfrtip',
            "buttons": [
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5'
            ],
            "oLanguage": {
                'sProcessing': '<i class="fa fa-circle-o-notch fa-spin" style="font-size:24px;color:#a377b1;"></i>'
            },
            "lengthMenu": [[10, 25, 50, 100, 1000000], [10, 25, 50, 100, "All"]],
            "processing": true,
            "serverSide": true,
            "ajax":{
                     "url": "<?php echo e(route('admin.user.row')); ?>",
                     "dataType": "json",
                     "type": "POST",
                     "data":{ _token: "<?php echo e(csrf_token()); ?>"}
                   },
            "columns": [
                { "data": "id" },
                { "data": "name" },
                { "data": "email" },
                { "data": "mobile" },
                { "data": "rating" },
                { "data": "corporate" },
                { "data": "action" },
            ]    

        });
    }

    $(window).load(function(){
        update_content();
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/ezrapp/resources/views/admin/users/index.blade.php ENDPATH**/ ?>